% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_analysis.R
\name{meta_analysis}
\alias{meta_analysis}
\title{Random-effects meta-analyses}
\usage{
meta_analysis(
  data,
  type = "parametric",
  random = "mixture",
  k = 2L,
  conf.level = 0.95,
  ...
)
}
\arguments{
\item{data}{A dataframe. It \strong{must} contain columns named \code{estimate} (effect
sizes or outcomes)  and \code{std.error} (corresponding standard errors). These
two columns will be used:
\itemize{
\item as \code{yi}  and \code{sei} arguments in \code{metafor::rma} (for \strong{parametric} test)
or \code{metaplus::metaplus} (for \strong{robust} test)
\item as \code{y} and \code{SE} arguments in \code{metaBMA::meta_random} (for \strong{Bayesian}
test).
}}

\item{type}{A character specifying the type of statistical approach:
\itemize{
\item \code{"parametric"}
\item \code{"nonparametric"}
\item \code{"robust"}
\item \code{"bayes"}
}

You can specify just the initial letter.}

\item{random}{
The type of random effects distribution. One of "normal", "t-dist", "mixture", for standard normal, \eqn{t}-distribution or mixture of normals respectively.
}

\item{k}{Number of digits after decimal point (should be an integer)
(Default: \code{k = 2L}).}

\item{conf.level}{Scalar between \code{0} and \code{1}. If unspecified, the defaults
return \verb{95\%} confidence/credible intervals (\code{0.95}).}

\item{...}{Additional arguments passed to the respective meta-analysis
function.}
}
\value{
The returned tibble data frame can contain some or all of the following columns (the exact columns will depend on the statistical test):
\itemize{
\item \code{statistic}: the numeric value of a statistic
\item \code{df}: the numeric value of a parameter being modeled (often degrees
of freedom for the test)
\item \code{df.error} and \code{df}: relevant only if the statistic in question has
two degrees of freedom (e.g. anova)
\item \code{p.value}: the two-sided \emph{p}-value associated with the observed statistic
\item \code{method}: the name of the inferential statistical test
\item \code{estimate}: estimated value of the effect size
\item \code{conf.low}: lower bound for the effect size estimate
\item \code{conf.high}: upper bound for the effect size estimate
\item \code{conf.level}: width of the confidence interval
\item \code{conf.method}: method used to compute confidence interval
\item \code{conf.distribution}: statistical distribution for the effect
\item \code{effectsize}: the name of the effect size
\item \code{n.obs}: number of observations
\item \code{expression}: pre-formatted expression containing statistical details
}

For examples of dataframe outputs, see examples and \href{https://indrajeetpatil.github.io/statsExpressions/articles/web_only/dataframe_outputs.html}{this vignette}.

Note that all examples are preceded by \code{set.seed()} calls for reproducibility.
}
\description{
The table below provides summary about:
\itemize{
\item statistical test carried out for inferential statistics
\item type of effect size estimate and a measure of uncertainty for this estimate
\item functions used internally to compute these details
}

\strong{Hypothesis testing} and \strong{Effect size estimation}\tabular{llll}{
   Type \tab Test \tab CI available? \tab Function used \cr
   Parametric \tab Pearson's correlation coefficient \tab Yes \tab \code{correlation::correlation()} \cr
   Non-parametric \tab Spearman's rank correlation coefficient \tab Yes \tab \code{correlation::correlation()} \cr
   Robust \tab Winsorized Pearson correlation coefficient \tab Yes \tab \code{correlation::correlation()} \cr
   Bayesian \tab Bayesian Pearson's correlation coefficient \tab Yes \tab \code{correlation::correlation()} \cr
}
}
\note{
\strong{Important}: The function assumes that you have already downloaded the
needed package (\code{{metafor}}, \code{{metaplus}}, or \code{{metaBMA}}) for meta-analysis.
If they are not available, you will be asked to install them.
}
\examples{
\donttest{
# a dataframe with estimates and standard errors (`mag` dataset from `{metaplus}`)
df <- structure(list(
  study = structure(c(
    8L, 10L, 15L, 1L, 4L, 11L, 3L, 2L, 14L, 9L, 12L, 5L, 16L, 7L, 13L, 6L
  ), .Label = c(
    "Abraham", "Bertschat", "Ceremuzynski", "Feldstedt", "Golf",
    "ISIS-4", "LIMIT-2", "Morton", "Pereira", "Rasmussen", "Schechter", "Schechter 1",
    "Schechter 2", "Singh", "Smith", "Thogersen"
  ), class = "factor"),
  estimate = c(
    -0.8303483, -1.056053, -1.27834, -0.0434851, 0.2231435,
    -2.40752, -1.280934, -1.191703, -0.695748, -2.208274, -2.03816,
    -0.8501509, -0.7932307, -0.2993399, -1.570789, 0.0575873
  ),
  std.error = c(
    1.24701799987009, 0.41407060026039, 0.808139200261935,
    1.42950999996502, 0.489168400451215, 1.07220799987689, 1.1937340001022,
    1.66129199992054, 0.536177600240816, 1.10964800004326, 0.780726300312728,
    0.618448600127771, 0.625866199758383, 0.146572899950844,
    0.574039500383031, 0.0316420922190679
  )
), row.names = c(NA, -16L), class = "data.frame")

# setup
set.seed(123)
library(statsExpressions)
options(tibble.width = Inf, pillar.bold = TRUE, pillar.neg = TRUE)

meta_analysis(df) # parametric
# meta_analysis(df, type = "random", random = "normal") # robust
# meta_analysis(df, type = "bayes") # Bayesian
}
}
