% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_analysis.R
\name{meta_analysis}
\alias{meta_analysis}
\title{Random-effects meta-analysis}
\usage{
meta_analysis(
  data,
  type = "parametric",
  random = "mixture",
  k = 2L,
  conf.level = 0.95,
  ...
)
}
\arguments{
\item{data}{A data frame. It \strong{must} contain columns named \code{estimate} (effect
sizes or outcomes)  and \code{std.error} (corresponding standard errors). These
two columns will be used:
\itemize{
\item as \code{yi}  and \code{sei} arguments in \code{metafor::rma} (for \strong{parametric} test)
or \code{metaplus::metaplus} (for \strong{robust} test)
\item as \code{y} and \code{SE} arguments in \code{metaBMA::meta_random} (for \strong{Bayesian}
test).
}}

\item{type}{A character specifying the type of statistical approach:
\itemize{
\item \code{"parametric"}
\item \code{"nonparametric"}
\item \code{"robust"}
\item \code{"bayes"}
}

You can specify just the initial letter.}

\item{random}{
The type of random effects distribution. One of "normal", "t-dist", "mixture", for standard normal, \eqn{t}-distribution or mixture of normals respectively.
}

\item{k}{Number of digits after decimal point (should be an integer)
(Default: \code{k = 2L}).}

\item{conf.level}{Scalar between \code{0} and \code{1} (default: \verb{95\%}
confidence/credible intervals, \code{0.95}). If \code{NULL}, no confidence intervals
will be computed.}

\item{...}{Additional arguments passed to the respective meta-analysis
function.}
}
\value{
The returned tibble data frame can contain some or all of the following columns (the exact columns will depend on the statistical test):
\itemize{
\item \code{statistic}: the numeric value of a statistic
\item \code{df}: the numeric value of a parameter being modeled (often degrees
of freedom for the test)
\item \code{df.error} and \code{df}: relevant only if the statistic in question has
two degrees of freedom (e.g. anova)
\item \code{p.value}: the two-sided \emph{p}-value associated with the observed statistic
\item \code{method}: the name of the inferential statistical test
\item \code{estimate}: estimated value of the effect size
\item \code{conf.low}: lower bound for the effect size estimate
\item \code{conf.high}: upper bound for the effect size estimate
\item \code{conf.level}: width of the confidence interval
\item \code{conf.method}: method used to compute confidence interval
\item \code{conf.distribution}: statistical distribution for the effect
\item \code{effectsize}: the name of the effect size
\item \code{n.obs}: number of observations
\item \code{expression}: pre-formatted expression containing statistical details
}

For examples of dataframe outputs, see examples and \href{https://indrajeetpatil.github.io/statsExpressions/articles/web_only/dataframe_outputs.html}{this vignette}.

Note that all examples are preceded by \code{set.seed()} calls for reproducibility.
}
\description{
Parametric, non-parametric, robust, and Bayesian random-effects meta-analysis.
}
\note{
\strong{Important}: The function assumes that you have already downloaded the
needed package (\code{{metafor}}, \code{{metaplus}}, or \code{{metaBMA}}) for meta-analysis.
If they are not available, you will be asked to install them.
}
\section{Random-effects meta-analysis}{


The table below provides summary about:
\itemize{
\item statistical test carried out for inferential statistics
\item type of effect size estimate and a measure of uncertainty for this estimate
\item functions used internally to compute these details
}

\strong{Hypothesis testing} and \strong{Effect size estimation}\tabular{llll}{
   Type \tab Test \tab CI available? \tab Function used \cr
   Parametric \tab Pearson's correlation coefficient \tab Yes \tab \code{correlation::correlation()} \cr
   Non-parametric \tab Spearman's rank correlation coefficient \tab Yes \tab \code{correlation::correlation()} \cr
   Robust \tab Winsorized Pearson's correlation coefficient \tab Yes \tab \code{correlation::correlation()} \cr
   Bayesian \tab Bayesian Pearson's correlation coefficient \tab Yes \tab \code{correlation::correlation()} \cr
}
}

\examples{
\dontshow{if (identical(Sys.getenv("NOT_CRAN"), "true") && requireNamespace("metafor", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# setup
set.seed(123)
library(statsExpressions)
options(tibble.width = Inf, pillar.bold = TRUE, pillar.neg = TRUE)

# a data frame with estimates and standard errors (`mag` dataset from `{metaplus}`)
df <- tibble::tribble(
  ~study, ~estimate, ~std.error,
  "Abraham", -0.83, 1.247,
  "Bertschat", -1.056, 0.414,
  "Ceremuzynski", -1.278, 0.808,
  "Feldstedt", -0.043, 1.429,
  "Golf", 0.223, 0.489,
  "ISIS-4", -2.407, 1.072,
  "LIMIT-2", -1.28, 1.193,
  "Morton", -1.191, 1.661,
  "Pereira", -0.695, 0.536,
  "Rasmussen", -2.208, 1.109,
  "Schechter", -2.038, 0.78,
  "Schechter 1", -0.85, 0.618,
  "Schechter 2", -0.793, 0.625,
  "Singh", -0.299, 0.146,
  "Smith", -1.57, 0.574,
  "Thogersen", 0.057, 0.031
)

# parametric
meta_analysis(df)
\dontshow{\}) # examplesIf}
\dontshow{if (identical(Sys.getenv("NOT_CRAN"), "true") && requireNamespace("metaplus", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# robust
meta_analysis(df, type = "random", random = "normal")
\dontshow{\}) # examplesIf}
\dontshow{if (identical(Sys.getenv("NOT_CRAN"), "true") && requireNamespace("metaBMA", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Bayesian
meta_analysis(df, type = "bayes") # Bayesian
\dontshow{\}) # examplesIf}
}
