% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add-expression-col.R
\name{add_expression_col}
\alias{add_expression_col}
\title{Template for expressions with statistical details}
\usage{
add_expression_col(
  data,
  paired = FALSE,
  statistic.text = NULL,
  effsize.text = NULL,
  prior.type = NULL,
  n = NULL,
  n.text = ifelse(paired, list(quote(italic("n")["pairs"])),
    list(quote(italic("n")["obs"]))),
  digits = 2L,
  digits.df = 0L,
  digits.df.error = digits.df,
  ...
)
}
\arguments{
\item{data}{A data frame containing details from the statistical analysis
and should contain some or all of the the following columns:
\itemize{
\item \emph{statistic}: the numeric value of a statistic.
\item \emph{df.error}: the numeric value of a parameter being modeled (often degrees
of freedom for the test); note that if there are no degrees of freedom (e.g.,
for non-parametric tests), this column will be irrelevant.
\item \emph{df}: relevant only if the statistic in question has two degrees of freedom.
\item \emph{p.value}: the two-sided \emph{p}-value associated with the observed statistic.
\item \emph{method}: method describing the test carried out.
\item \emph{effectsize}: name of the effect size (if not present, same as \code{method}).
\item \emph{estimate}: estimated value of the effect size.
\item \emph{conf.level}: width for the confidence intervals.
\item \emph{conf.low}: lower bound for effect size estimate.
\item \emph{conf.high}: upper bound for effect size estimate.
\item \emph{bf10}: Bayes Factor value (if \code{bayesian = TRUE}).
}}

\item{paired}{Logical that decides whether the experimental design is
repeated measures/within-subjects or between-subjects. The default is
\code{FALSE}.}

\item{statistic.text}{A character that specifies the relevant test statistic.
For example, for tests with \emph{t}-statistic, \code{statistic.text = "t"}.}

\item{effsize.text}{A character that specifies the relevant effect size.}

\item{prior.type}{The type of prior.}

\item{n}{An integer specifying the sample size used for the test.}

\item{n.text}{A character that specifies the design, which will determine
what the \code{n} stands for. It defaults to \code{quote(italic("n")["pairs"])} if
\code{paired = TRUE}, and to \code{quote(italic("n")["obs"])} if \code{paired = FALSE}. If
you wish to customize this further, you will need to provide object of
\code{language} type.}

\item{digits, digits.df, digits.df.error}{Number of decimal places to display for the
parameters (default: \code{0L}).}

\item{...}{Currently ignored.}
}
\description{
Creates an expression from a data frame containing statistical details.
Ideally, this data frame would come from having run \code{tidy_model_parameters}
function on your model object.

This function is currently \strong{not} stable and should not be used outside of
this package context.
}
\examples{
set.seed(123)

# creating a data frame with stats results
stats_df <- cbind.data.frame(
  statistic  = 5.494,
  df         = 29.234,
  p.value    = 0.00001,
  estimate   = -1.980,
  conf.level = 0.95,
  conf.low   = -2.873,
  conf.high  = -1.088,
  method     = "Student's t-test"
)

# expression for *t*-statistic with Cohen's *d* as effect size
# note that the plotmath expressions need to be quoted
add_expression_col(
  data           = stats_df,
  statistic.text = list(quote(italic("t"))),
  effsize.text   = list(quote(italic("d"))),
  n              = 32L,
  n.text         = list(quote(italic("n")["no.obs"])),
  digits         = 3L,
  digits.df      = 3L
)
}
