% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/meas_error.R
\name{meas_error}
\alias{meas_error}
\title{Add measurement error to datasets}
\usage{
meas_error(data, case.ids, outcome, conditions, type,
 error.level, fuzzy.range, reps, analyze, max.cond.plot, ...)
}
\arguments{
\item{data}{a data frame}

\item{case.ids}{optional character vector containing variable names that identify cases}

\item{outcome}{a character string containing the name of the outcome variable}

\item{conditions}{optional character vector indicating explanatory variables}

\item{type}{a character string indicating the type of set membership scores in the data; takes either
"crisp" for crisp-set data, or "fuzzy" for fuzzy-set data}

\item{error.level}{a numeric vector indicating the proportion of data points that should be
perturbed with every iteration}

\item{fuzzy.range}{bandwidth around a data point used for sampling fuzzy-set membership scores
from a uniform distribution}

\item{reps}{number of perturbed datasets to create}

\item{analyze}{logical; if TRUE, carry out frequency analysis of conditions}

\item{max.cond.plot}{maximum number of conditions to plot for frequency analysis}

\item{...}{optional arguments passed to \code{eqmcc()}}
}
\value{
Returns a named list containing the following components:

\item{\code{parameter.specs}}{a data frame containing parameter specifications used to generate each subset of the data frames list}
\item{\code{datasets}}{a list of data frames containing measurement error}
\item{\code{result.freq}}{a data frame containing counts of condition appearances}
\item{\code{plot}}{a plot of condition frequencies (per solution)}
}
\description{
\code{meas_error} creates a list of datasets that contain a
specified type and level of measurement error
}
\examples{
# Load data
data(hicks_29)

# Run function, get measurement error in 1, 5, and 10\% of the data points
a<-meas_error(data = hicks_29, case.ids = "Case", outcome = "CON", type = "crisp",
error.level = c(0.01, 0.05, 0.1), reps = 200, analyze=FALSE)

# Get parameter specifications
a$parameter.specs

# Isolate list of datasets with 5\% measurement error
a$datasets[[2]]

# Load data
data(hh)

# Run function, get measurement error in 1, 5, and 10\% of the data points
a<-meas_error(data = hh, case.ids = "Country", outcome = "success", type = "fuzzy",
error.level = c(0.01, 0.05, 0.1), reps = 200, analyze=FALSE)

# Get parameter specifications
a$parameter.specs

# Isolate list of datasets with 10\% measurement error
a$datasets[[3]]
}

