% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getOffers_Account.R
\name{getOffers_Account}
\alias{getOffers_Account}
\title{Get an overview of offers on the Stellar ledger.}
\usage{
getOffers_Account(public_key, cursor = NULL, limit = NULL, order = "asc",
  data.table = TRUE)
}
\arguments{
\item{public_key}{character - your Stellar account/wallet address.}

\item{cursor}{numeric - optional, a paging token - where to start from. Can also be "now".}

\item{limit}{numeric - optional, the number of records to return.}

\item{order}{character - optional, "asc" or "desc"}

\item{data.table}{boolean - if TRUE, a data.table is returned. If FALSE or NULL, a list is returned.}
}
\value{
list
}
\description{
Returns offers with a particular account. Converts the JSON response to a list.
}
\note{
https://www.stellar.org/developers/horizon/reference/endpoints/offers-for-account.html
}
\examples{
\donttest{getOffers_Account("GsomeAccount")}
}
