% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ps_spells.R
\name{ps_spells}
\alias{ps_spells}
\title{Create "spells" by cross-sectional unit, even more generally}
\usage{
ps_spells(data, event, tvar, csunit, time_type = "year", ongoing = FALSE)
}
\arguments{
\item{data}{the data set with which you are working}

\item{event}{some event (0, 1) for which you want spells}

\item{tvar}{the time variable (e.g. a year)}

\item{csunit}{the cross-sectional unit (e.g. a dyad or leader)}

\item{time_type}{what type of time-unit are the data? Right now, this will only work with years but support for months and days are forthcoming. Don't do anything with this argument just yet.}

\item{ongoing}{If \code{TRUE}, successive 1s are considered ongoing events
and treated as \code{NA} after the first 1. If \code{FALSE}, successive 1s
are all treated as failures. Defaults to \code{FALSE}.}
}
\value{
\code{ps_spells()} takes a data frame and returns the data frame with a new variable
named \code{spell}.
}
\description{
\code{ps_spells()} allows you to create spells ("peace years" in
the international conflict context) between observations of some event. This
will allow the researcher to better model temporal dependence in binary time-series
cross-section ("BTSCS") models. The function is one of three in this package, and the contents
of this function are partly ported from the \code{add_duration()} function in the \pkg{spduration}
package. That function, unlike the other two I offer here, works much better where panels are decidedly
imbalanced.
}
\details{
This function is derived from \code{add_duration()}  in the \pkg{spduration}
package. See documentation there for more information. I thank Andreas Beger for the blessing to port parts of
it here.
}
\examples{
\donttest{
One <- ps_btscs(usa_mids, midongoing, year, dyad)
Two <- ps_spells(usa_mids, midongoing, year, dyad)
identical(One, Two)
}

}
\references{
Beger, Andreas, Daina Chiba, Daniel W. Hill, Jr, Nils W. Metternich, Shahryar Minhas and Michael D. Ward. 2018.
``\pkg{spduration}: Split-Population and Duration (Cure) Regression.'' \emph{R package version 0.17.1}.
}
\author{
Andreas Beger, Steven V. Miller
}
