% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funs.R
\name{stickr_get}
\alias{stickr_get}
\title{Get hex sticker from web}
\usage{
stickr_get(
  name,
  destfile = NULL,
  view = TRUE,
  filename = NULL,
  path = NULL,
  repo = NULL
)
}
\arguments{
\item{name}{name of sticker, character of length 1}

\item{destfile}{destination, defaults to \code{NULL}}

\item{view}{show sticker after loading? Defaults to \code{TRUE}}

\item{filename}{filename of sticker in repository, use if auto-detection fails}

\item{path}{path within repository, use if auto-detection fails}

\item{repo}{repository name, use if auto-detection fails}
}
\value{
path to downloaded image
}
\description{
This function \emph{tries} to search for the sticker for the package you want. If
the package is one with a sticker in the
\href{https://github.com/rstudio/hex-stickers}{rstudio/hex-stickers} repository,
it will come from there. If you want SVG rather than PNG, specify a filename.
}
\details{
If not, this function attempts to get the package's GitHub repository from the
package description, and look for the sticker in the man/figures directory.

In case this function cannot find the sticker, escape hatches are provided
for specifying the repository, path within the repository, and filename of the sticker
you want.

Packages stored somewhere other than GitHub are currently unsupported.

If you hit rate limits on GitHub API calls, consider setting the \code{GITHUB_PAT} environment variable.
See \code{\link[gh:gh]{gh::gh()}} for details.
}
\examples{
# Get a sticker
if(interactive()) r6 <- stickr_get("R6")
# Get a sticker in svg
if(interactive()) r6 <- stickr_get("R6", filename = "R6.svg")
# Get a particular sticker in the man/figures folder
if(interactive()) tm <- stickr_get("textmineR", filename = "textmineR_v8.png")
}
