% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/STMlncpp.R
\name{optimizeDocument}
\alias{optimizeDocument}
\title{Optimize Document}
\usage{
optimizeDocument(document, eta, mu, beta, sigma = NULL,
  sigmainv = NULL, sigmaentropy = NULL, method = "BFGS",
  control = list(maxit = 500), posterior = TRUE)
}
\arguments{
\item{document}{a single matrix containing the document in the \code{\link{stm}} format}

\item{eta}{a vector of length K-1 containing the initial starting value for eta}

\item{mu}{a vector of length K-1 containing the prevalence prior}

\item{beta}{a matrix containing the complete topic-word distribution for the document.
If using a content covariate model it is presumed that you have already passed the correct content
covariate level's beta.}

\item{sigma}{a K-1 by K-1 matrix containing the covariance matrix of the MVN prior. If you supply this
you do not need to supply \code{sigmainv} or \code{sigmaentropy}.  See below.}

\item{sigmainv}{a K-1 by K-1 matrix containing the precision matrix of the MVN prior.  If you supplied
\code{sigma} you do not need to supply this. See below.}

\item{sigmaentropy}{the entropy term calculated from sigma.  If you supplied \code{sigma} you do not
need to supply this.  See below.}

\item{method}{the method passed to \code{\link{optim}}.  Uses "BFGS" by default.}

\item{control}{the control argument passed to \code{\link{optim}}.  Sets the maximum number of observations
to 500 but can be used to set other aspects of the optimization per the instructions in \code{\link{optim}}}

\item{posterior}{should the full posterior be returned?  If TRUE (as it is by default) returns the full 
variational posterior.  Otherwise just returns the point estimate.}
}
\value{
a list 

\item{phis}{A K by V* matrix containing the variational distribution for each token (where V* is the number of 
unique words in the given document.  They are in the order of appearance in the document. For words repeated
more than once the sum of the column is the number of times that token appeared.}
\item{lambda}{A (K-1) by 1 matrix containing the mean of the variational distribution for eta.  This is 
actually just called eta in the output of \code{\link{stm}} as it is also the point estimate.}
\item{nu}{A (K-1) by (K-1) matrix containing the covariance matrix of the variational distribution for eta.
This is also the inverse Hessian matrix.}
\item{bound}{The value of the document-level contribution to the global approximate evidence lower bound.}
}
\description{
A primarily internal use function for optimizing the document-level
parameters of the variational distribution.  
Included here for advanced users who want to design new
post-processing features. This help file assumes knowledge of our 
notation which follows the mathematical notation used in our vignette
and other papers.
}
\details{
This function is a small wrapper around the internal function used
to complete the E-step for each document.

Regarding the arguments \code{sigma}, \code{sigmainv} and \code{sigmaentropy}.  In
the internal version of the code we calculate \code{sigmainv} and \code{sigmaentropy}
once each E-step because it is shared by all documents.  If you supply the original
value to \code{sigma} it will calculate these for you.  If you are going to be using
this to run a bunch of documents and speed is a concern, peek at the underlying code
and do the calculation yourself once and then just pass the result to the function so
it isn't repeated with every observation.
}
\examples{
# fitting to a nonsense word distribution
V <- length(poliblog5k.voc)
K <- 50
beta <- matrix(rgamma(V*K,shape = .1), nrow=K, ncol=V)
beta <- beta/rowSums(beta)
doc <- poliblog5k.docs[[1]]
mu <- rep(0, K-1)
sigma <- diag(1000, nrow=K-1)
optimizeDocument(doc, eta=rep(0, K-1), mu=mu, beta=beta, sigma=sigma)
}
\seealso{
\code{\link{thetaPosterior}}
}
