% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/infl.R
\name{infl}
\alias{infl}
\title{Display outlying LISTA functions}
\usage{
infl(x, id = NULL)
}
\arguments{
\item{x}{An object of class \code{localdiag}}

\item{id}{The id of the LISTA to display.
Default is set to the ids identified and stored in the \code{localdiag} object}
}
\description{
This function works on the objects of class \code{localdiag}, as returned by
\link{localdiag}, plotting the identified 'outlying'
LISTA functions. These correspond to the influential points in the fitting
of the model provided by \link{localdiag}
}
\examples{

\donttest{
inh <- rstpp(lambda = function(x, y, t, a) {exp(a[1] + a[2]*x)}, 
             par = c(.3, 6), seed = 2)

mod1 <- stppm(inh, formula = ~ 1)

resmod1 <- localdiag(inh, mod1$l, p = .9)

infl(resmod1)

}


}
\references{
Adelfio, G., Siino, M., Mateu, J., and Rodríguez-Cortés, F. J. (2020). Some properties of local weighted second-order statistics for spatio-temporal point processes. Stochastic Environmental Research and Risk Assessment, 34(1), 149-168.

D’Angelo, N., Adelfio, G.  and Mateu, J. (2022) Local inhomogeneous second-order characteristics for spatio-temporal point processes on linear networks. Stat Papers. https://doi.org/10.1007/s00362-022-01338-4
}
\seealso{
\link{localdiag}, \link{plot.localdiag},
 \link{print.localdiag}, \link{summary.localdiag}
}
\author{
Nicoletta D'Angelo and Giada Adelfio
}
