% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.rule.bin.R
\name{plot.rule.bin}
\alias{plot.rule.bin}
\title{Plot Stopping Rule (Binary Data)}
\usage{
\method{plot}{rule.bin}(
  x,
  smooth = TRUE,
  xlim = c(0, max(x$ns)),
  ylim = c(0, max(x$Rule[, 2]) + 1),
  xlab = "# Evaluable",
  ylab = "# Events",
  ...
)
}
\arguments{
\item{x}{A 'rule.bin' object calculated by \code{calc.rule.bin()} function}

\item{smooth}{Binary indicator of whether stopping rule boundary should be smoothed by linear interpolation between evaluation points}

\item{xlim}{The x limits (x1, x2) of the plot. Note that x1 > x2 is allowed and leads to a ‘reversed axis’.}

\item{ylim}{The y limits of the plot.}

\item{xlab}{The title for the x axis}

\item{ylab}{The title for the y axis}

\item{...}{Other options to be passed to generic \code{plot} function}
}
\value{
No return value; function solely generates a plot
}
\description{
Display a stopping rule graphically as a curve
}
\examples{
# Binomial Pocock test in 50 patient cohort at 10\% level, expected toxicity probability of 20\%
poc_rule = calc.rule.bin(ns=1:50,p0=0.20,alpha=0.10,type="Pocock")

# Plot stopping boundary with smoothing
plot(poc_rule,col="blue")
}
