% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stop_elastic.R
\name{stop_elastic}
\alias{stop_elastic}
\title{STOPS versions of elastic scaling models (via smacofSym)}
\usage{
stop_elastic(
  dis,
  theta = 1,
  type = "ratio",
  ndim = 2,
  weightmat = 1 - diag(nrow(dis)),
  init = NULL,
  itmaxi = 1000,
  ...,
  stressweight = 1,
  structures = c("cclusteredness", "clinearity", "cdependence", "cmanifoldness",
    "cassociation", "cnonmonotonicity", "cfunctionality", "ccomplexity", "cfaithfulness",
    "cregularity", "chierarchy", "cconvexity", "cstriatedness", "coutlying",
    "cskinniness", "csparsity", "cstringiness", "cclumpiness", "cinequality"),
  strucweight = rep(1/length(structures), length(structures)),
  strucpars,
  verbose = 0,
  stoptype = c("additive", "multiplicative"),
  registry = struc_reg
)
}
\arguments{
\item{dis}{numeric matrix or dist object of a matrix of proximities}

\item{theta}{the theta vector of powers; this must be a scalar of the lambda transformation for the observed proximities. Defaults to 1.}

\item{type}{MDS type. Defaults ot 'ratio'.}

\item{ndim}{number of dimensions of the target space}

\item{weightmat}{(optional) a matrix of nonnegative weights (NOT the elscal weights)}

\item{init}{(optional) initial configuration}

\item{itmaxi}{number of iterations}

\item{...}{additional arguments to be passed to the fitting procedure}

\item{stressweight}{weight to be used for the fit measure; defaults to 1}

\item{structures}{which structuredness indices to be included in the loss}

\item{strucweight}{weight to be used for the structuredness indices; ; defaults to 1/#number of structures}

\item{strucpars}{the parameters for the structuredness indices}

\item{verbose}{numeric value hat prints information on the fitting process; >2 is extremely verbose}

\item{stoptype}{How to construct the target function for the multi objective optimization? Either 'additive' (default) or 'multiplicative'}

\item{registry}{registry object with c-structuredness indices.}
}
\value{
A list with the components
   \itemize{
        \item{stress:} the stress-1 (sqrt(stress.m))
        \item{stress.m:} default normalized stress (used for STOPS)
        \item{stoploss:} the weighted loss value
        \item{indices:} the values of the structuredness indices
        \item{parameters:} the parameters used for fitting (lambda)
        \item{fit:} the returned object of the fitting procedure
        \item{stopobj:} the stopobj objects
}
}
\description{
The free parameter is lambda for power transformations the observed proximities. The fitted distances power is internally fixed to 1 and the power for the weights=delta is -2. Allows for a weight matrix because of smacof.
}
\keyword{multivariate}
