% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_winds.R
\name{interp_track}
\alias{interp_track}
\title{Interpolate a storm track}
\usage{
interp_track(track, tint = 0.25)
}
\arguments{
\item{track}{A dataframe with hurricane track data for a single storm. See
the \code{\link{floyd_tracks}} dataset that comes with the package for
an example of the required format for this dataframe.}

\item{tint}{A numeric vector giving the time interval to impute to, in units
of hours (e.g., 0.25, the default, interpolates to 15 minute-intervals).}
}
\value{
A dataframe with hurricane track data for a single storm,
   interpolated to the interval specified by \code{tint}.
}
\description{
This function takes a wider-spaced storm track (e.g., every 6 hours) and
interpolates to a finer interval (e.g., every 15 minutes). To do this, it
fits GLMs of latitude and longitude regressed on natural cubic splines of
date-time, and then predicts these splines to new intervals. These
splines use degrees of freedom equal to the number of original observations
divided by two.
}
