% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/od-funs.R
\name{od_aggregate_to}
\alias{od_aggregate_to}
\title{Summary statistics of trips arriving at destination zones in OD data}
\usage{
od_aggregate_to(flow, attrib = NULL, FUN = sum, ..., col = 2)
}
\arguments{
\item{flow}{A data frame representing the flow between two points
or zones. The first two columns of this data frame should correspond
to the first column of the data in the zones. Thus in \code{\link[=cents]{cents()}},
the first column is geo_code. This corresponds to the first two columns
of \code{\link[=flow]{flow()}}.}

\item{attrib}{A character vector corresponding to the variables in
\code{sl$} on which the function(s) will operate.}

\item{FUN}{A function to summarise OD data by}

\item{...}{Additional arguments passed to \code{FUN}}

\item{col}{The column that the OD dataset is grouped by (1 by default, the first column usually represents the origin)}
}
\description{
This function takes a data frame of OD data and
returns a data frame reporting summary statistics for each unique zone of destination.
}
\details{
It has some default settings: it assumes the destination ID column is the 2nd
and the default summary statistic is \code{sum()}.
By default, if \code{attrib} is not set, it summarises all numeric columns.
}
\examples{
od_aggregate_to(flow)
}
\seealso{
Other od: \code{\link{dist_google}}, \code{\link{od2line}},
  \code{\link{od2odf}}, \code{\link{od_aggregate_from}},
  \code{\link{od_aggregate}}, \code{\link{od_coords2line}},
  \code{\link{od_coords}}, \code{\link{od_dist}},
  \code{\link{od_radiation}}, \code{\link{points2flow}},
  \code{\link{points2odf}}, \code{\link{sp_aggregate}}
}
\concept{od}
