% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/route.R
\name{route}
\alias{route}
\title{Plan routes on the transport network}
\usage{
route(
  from = NULL,
  to = NULL,
  l = NULL,
  route_fun = stplanr::route_cyclestreets,
  n_print = 10,
  list_output = FALSE,
  cl = NULL,
  ...
)
}
\arguments{
\item{from}{An object representing origins
(if lines are provided as the first argument, from is assigned to \code{l})}

\item{to}{An object representing destinations}

\item{l}{Only needed if from and to are empty, in which case this
should be a spatial object representing desire lines}

\item{route_fun}{A routing function to be used for converting the straight lines to routes
\code{\link[=od2line]{od2line()}}}

\item{n_print}{A number specifying how frequently progress updates
should be shown}

\item{list_output}{If FALSE (default) assumes spatial (linestring) object output. Set to TRUE to save output as a list.}

\item{cl}{Cluster}

\item{...}{Arguments passed to the routing function, e.g. \code{\link[=route_cyclestreets]{route_cyclestreets()}}}
}
\description{
Takes origins and destinations, finds the optimal routes between them
and returns the result as a spatial (sf or sp) object.
The definition of optimal depends on the routing function used
}
\examples{
r <- overline(routes_fast_sf, "length")
l <- od2line(od_data_sample[2:5, 1:3], cents_sf)
sln <- stplanr::SpatialLinesNetwork(r)
# calculate shortest paths
plot(sln)
plot(l$geometry, add = TRUE)
sp <- stplanr::route(
  l = l,
  route_fun = stplanr::route_local,
  sln = sln
)
plot(sp["all"], add = TRUE, lwd = 5)
\donttest{
# these lines require API keys/osrm instances
from <- c(-1.5484, 53.7941) # from <- geo_code("leeds rail station")
to <-   c(-1.5524, 53.8038) # to <- geo_code("university of leeds")
r1 <- route(from, to, route_fun = cyclestreets::journey)
r2 <- route(from, to, route_fun = cyclestreets::journey, plan = "quietest")
plot(r1)
plot(r2)
r = route(cents_sf[1:3, ], cents_sf[2:4, ], route_fun = cyclestreets::journey) # sf points
summary(r$route_number)
dl <- od2line(od_data_sample[1:3, ], cents_sf)
route(dl, route_fun = cyclestreets::journey)
route(dl, route_fun = cyclestreets::journey, plan = "quietest")
route(dl, route_fun = cyclestreets::journey, plan = "balanced")
route(dl, route_fun = cyclestreets::journey, list_output = TRUE)
route(dl, route_fun = cyclestreets::journey, save_raw = TRUE, list_output = TRUE)
# with osrm backend - need to set-up osrm first - see routing vignette
if(require(osrm)) {
  message("You have osrm installed")
  osrm::osrmRoute(c(-1.5, 53.8), c(-1.51, 53.81))
  osrm::osrmRoute(c(-1.5, 53.8), c(-1.51, 53.81), , returnclass = "sf")
  # mapview::mapview(.Last.value) # check it's on the route network
  route(l = pct::wight_lines_30[1:2, ], route_fun = osrm::osrmRoute, returnclass = "sf")
}
if(require(cyclestreets)) { # with cyclestreets backend
  l <- pct::wight_lines_30
  system.time(r <- route(l, route_fun = cyclestreets::journey))
  plot(r)
  library(parallel)
  library(cyclestreets)
  cl <- makeCluster(detectCores())
  clusterExport(cl, c("journey"))
  system.time(r2 <- route(l, route_fun = cyclestreets::journey, cl = cl))
  plot(r2)
  identical(r, r2)
  stopCluster(cl)
}
}
}
\seealso{
Other routes: 
\code{\link{line2routeRetry}()},
\code{\link{line2route}()},
\code{\link{route_dodgr}()},
\code{\link{route_graphhopper}()},
\code{\link{route_local}()},
\code{\link{route_transportapi_public}()}
}
\concept{routes}
