% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprecated.R
\name{route_graphhopper}
\alias{route_graphhopper}
\title{Plan a route with the graphhopper routing engine}
\usage{
route_graphhopper(
  from,
  to,
  l = NULL,
  vehicle = "bike",
  silent = TRUE,
  pat = NULL,
  base_url = "https://graphhopper.com"
)
}
\arguments{
\item{from}{Text string or coordinates (a numeric vector of
\code{length = 2} representing latitude and longitude) representing a point
on Earth.}

\item{to}{Text string or coordinates (a numeric vector of
\code{length = 2} representing latitude and longitude) representing a point
on Earth. This represents the destination of the trip.}

\item{l}{Only needed if from and to are empty, in which case this
should be a spatial object representing desire lines}

\item{vehicle}{A text string representing the vehicle.
Can be bike (default), car or foot. See \url{https://graphhopper.com/api/1/docs/supported-vehicle-profiles/} for further details.}

\item{silent}{Logical (default is FALSE). TRUE hides request sent.}

\item{pat}{The API key used. By default this is set to NULL and
this is usually aquired automatically through a helper, api_pat().}

\item{base_url}{The base url from which to construct API requests
(with default set to main server)}
}
\description{
\strong{Note: See https://github.com/crazycapivara/graphhopper-r for modern interface}
}
\details{
Provides an R interface to the graphhopper routing engine,
an open source route planning service.

The function returns a SpatialLinesDataFrame object.
See \url{https://github.com/graphhopper} for more information.

To test graphopper is working for you, try something like this, but with
your own API key:
To use this function you will need to obtain an API key from
\url{https://graphhopper.com/#directions-api}.
It is assumed that you have set your api key as a system environment
for security reasons (so you avoid typing the API key in your code).
Do this by adding the following to your .Renviron file (see \code{?.Renviron}
or the 'api-packages' vignette at \url{https://cran.r-project.org/package=httr}
for more on this):

\code{GRAPHHOPPER='FALSE-Key-eccbf612-214e-437d-8b73-06bdf9e6877d'}.

(Note: key not real, use your own key.)

\code{obj <- jsonlite::fromJSON(url)}

Where \code{url} is an example api request from
\url{https://github.com/graphhopper/directions-api/blob/master/routing.md}.
}
\examples{
# from <- c(-0.12, 51.5)
# to <- c(-0.14, 51.5)
# r1 <- route_graphhopper(from = from, to = to, silent = FALSE)
# r2 <- route_graphhopper(from = from, to = to, silent = FALSE, vehicle = "foot")
# r3 <- route_graphhopper(from = from, to = to, silent = FALSE, vehicle = "car")
# plot(r1)
# plot(r2, add = TRUE, col = "blue") # compare routes
# plot(r3, add = TRUE, col = "red")
}
\seealso{
route_cyclestreet

Other routes: 
\code{\link{line2routeRetry}()},
\code{\link{line2route}()},
\code{\link{route_dodgr}()},
\code{\link{route_local}()},
\code{\link{route_transportapi_public}()},
\code{\link{route}()}
}
\concept{routes}
