% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geo-functions.R
\name{geo_bb}
\alias{geo_bb}
\alias{bb2poly}
\title{Flexible function to generate bounding boxes}
\usage{
geo_bb(
  shp,
  scale_factor = 1,
  distance = 0,
  output = c("polygon", "points", "bb")
)
}
\arguments{
\item{shp}{Spatial object}

\item{scale_factor}{Numeric vector determining how much the bounding box will grow or shrink.
Two numbers refer to extending the bounding box in x and y dimensions, respectively.
If the value is 1, the output size will be the same as the input.}

\item{distance}{Distance in metres to extend the bounding box by}

\item{output}{Type of object returned (polygon by default)}
}
\description{
Takes a geographic object or bounding box as an input and outputs a bounding box,
represented as a bounding box, corner points or rectangular polygon.
}
\examples{
shp <- routes_fast_sf
shp_bb <- geo_bb(shp, distance = 100)
plot(shp_bb, col = "red", reset = FALSE)
plot(geo_bb(routes_fast_sf, scale_factor = 0.8), col = "green", add = TRUE)
plot(routes_fast_sf$geometry, add = TRUE)
geo_bb(shp, output = "point")
}
\seealso{
bb_scale

Other geo: 
\code{\link{bbox_scale}()},
\code{\link{bind_sf}()},
\code{\link{geo_bb_matrix}()},
\code{\link{geo_buffer}()},
\code{\link{geo_length}()},
\code{\link{geo_projected}()},
\code{\link{geo_select_aeq}()},
\code{\link{quadrant}()}
}
\concept{geo}
