% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spm_continuous.R
\name{spm_continuous}
\alias{spm_continuous}
\title{Continuous multi-dimensional optimization}
\usage{
spm_continuous(
  dat,
  a = -0.05,
  f1 = 80,
  Q = 2e-08,
  f = 80,
  b = 5,
  mu0 = 2e-05,
  theta = 0.08,
  stopifbound = FALSE,
  lb = NULL,
  ub = NULL,
  verbose = FALSE,
  pinv.tol = 0.01,
  gomp = FALSE,
  opts = list(algorithm = "NLOPT_LN_NELDERMEAD", maxeval = 100, ftol_rel = 1e-08),
  logmu0 = FALSE
)
}
\arguments{
\item{dat}{A data table.}

\item{a}{A starting value of the rate of adaptive response to any deviation of Y from f1(t).}

\item{f1}{A starting value of the average age trajectories of the variables which process is forced to follow.}

\item{Q}{Starting values of the quadratic hazard term.}

\item{f}{A starting value of the "optimal" value of variable which corresponds to the minimum of hazard rate at a respective time.}

\item{b}{A starting value of a diffusion coefficient representing a strength of the random disturbance from Wiener Process.}

\item{mu0}{A starting value of the baseline hazard.}

\item{theta}{A starting value of the parameter theta (axe displacement of Gompertz function).}

\item{stopifbound}{Estimation stops if at least one parameter achieves lower or upper boundaries.
#'Check the NLopt website for a description of
the algorithms. Default: NLOPT_LN_NELDERMEAD}

\item{lb}{Lower bound of parameters under estimation.}

\item{ub}{Upper bound of parameters under estimation.
The program stops when the number of function evaluations exceeds maxeval. Default: 500.}

\item{verbose}{An indicator of verbosing output.}

\item{pinv.tol}{A tolerance value for pseudo-inverse of matrix gamma (see Yashin, A.I. et al (2007). Stochastic model for analysis of longitudinal data on aging 
and mortality. Mathematical Biosciences, 208(2), 538-551.<DOI:10.1016/j.mbs.2006.11.006>.)}

\item{gomp}{A flag (FALSE by default). When it is set, then time-dependent exponential form of mu0 is used:
mu0 = mu0*exp(theta*t).}

\item{opts}{A list of options for \code{nloptr}.
Default value: \code{opt=list(algorithm="NLOPT_LN_NELDERMEAD", 
maxeval=100, ftol_rel=1e-8)}.
Please see \code{nloptr} documentation for more information.}

\item{logmu0}{Natural logarith of baseline mortality.
Default: \code{FALSE}.}
}
\value{
A set of estimated parameters a, f1, Q, f, b, mu0, theta and
additional variable \code{limit} which indicates if any parameter 
achieved lower or upper boundary conditions (FALSE by default).

status Optimization status (see documentation for nloptr package).

LogLik A logarithm likelihood.

objective A value of objective function (given by nloptr).

message A message given by nloptr optimization function (see documentation for nloptr package).
}
\description{
Continuous multi-dimensional optimization
}
\details{
\code{spm_continuous} runs much slower that discrete but more precise and can handle time 
intervals with different lengths.
}
\examples{
library(stpm)
#Reading the data:
data <- simdata_cont(N=2)
head(data)
#Parameters estimation:
pars <- spm_continuous(dat=data,a=-0.05, f1=80, 
					           Q=2e-8, f=80, b=5, mu0=2e-5)
pars

}
\references{
Yashin, A.I. et al (2007). Stochastic model for analysis of longitudinal data on aging 
and mortality. Mathematical Biosciences, 208(2), 538-551.<DOI:10.1016/j.mbs.2006.11.006>.
}
