% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/str2str_functions.R
\name{is.empty}
\alias{is.empty}
\title{Test for Empty Characters}
\usage{
is.empty(x, trim = FALSE)
}
\arguments{
\item{x}{character vector.}

\item{trim}{logical vector with a single element specifying whether white spaces
should be trimmed from the character vector. See \code{trimws}.}
}
\value{
TRUE for every element of `x` that is empty (i.e., "") and FALSE otherwise.
The structure is a logical vector with length = length(`x`) and names = names(`x`).
}
\description{
\code{is.empty} returns whether elements of a character vector are empty (i.e., "").
}
\examples{
v <- c("1", " ", "")
is.empty(v)
}
