% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/str2str_functions.R
\name{v2frm}
\alias{v2frm}
\title{Character Vector to Formula}
\usage{
v2frm(v, y = 1L, intercept = TRUE)
}
\arguments{
\item{v}{character vector of term(s) and/or response to be included on either
side of the returned formula. If it is not a character vector (e.g., factor,
numeric vector), then it is coerced to a character vector within \code{v2frm}.
Note, if the length of \code{v} is 1, then \code{y.which} must be NULL because
at least one term on the right hand side is required, otherwise an error is returned.}

\item{y}{character vector of length 1 specifying the value of the element
within \code{v}, or integer of length 1 specifying the position of the element
within \code{v}, that is the response to be placed on the left hand side of the
returned formula. If NULL, then no elements of \code{v} are treated as response(s)
and the left hand side is empty.}

\item{intercept}{logical vector of length 1 specifying whether the intercept should
be included in the returned formula. The default is TRUE and no change is made
to the returned formula. If FALSE, then a -1 is added to the end of the right hand side.}
}
\value{
formula with element \code{v[y]} on the left hand side and \code{v[-y]}
elements on the right hand side (rhs) separated by plus signs (+) with a -1
if \code{intercept} = FALSE.
}
\description{
\code{v2frm} converts a character vector to a formula. The formula has the
simple structure of y ~ x1 + x2 + x3 + ... + xn. This function is a simple
wrapper for \code{reformulate}.
}
\examples{
v2frm(v = names(attitude))
v2frm(v = names(attitude), y = 7L)
v2frm(v = names(attitude), y = NULL)
v2frm(v = "rating", y = NULL)
try_expr(v2frm(v = "rating")) # error is returned
}
