% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HP.mod.R
\name{HP.mod}
\alias{HP.mod}
\title{Heligman-Pollard parameter estimator using Bayesian Melding with Incremental Mixture Importance Sampling.}
\usage{
HP.mod(prior, lifeTab, K = 10, d = 10, B = 500, CI = 95, rm = 0)
}
\arguments{
\item{prior}{A matrix with dimensions (9000 * theta.dim) containing the prior distribution for each Heligman-Pollard parameter.}

\item{lifeTab}{A life table object from \link{life.tab} with a column containing the total number of individuals at risk of death in each age group.
A column containing the total number of deaths in each age group. Length should equal the length of age.
and a column of the ages at which the probabilities of death will be calculated.}

\item{K}{The number of IMIS iterations.}

\item{d}{The number of optimizer iterations.}

\item{B}{The sample size at each importance sampling iteration.}

\item{CI}{Defines the width of the confidence interval.
A summary table is printed with the median estimate and lower and upper confidence bounds.
Setting CI=95 prints a table with the first column representing the 2.5th percentile for each parameter distribution,
the second column represents the median value for each parameter distribution
and the third column represents the 97.5th percentile for each parameter distribution.}

\item{rm}{The number of age classes that want to be removed from optimization}
}
\value{
A list with:
\item{out}{A summary table of the results with the median parameter values in the middle column, the lower bound results in the left column, and upper bound result in the right column.}
\item{H.final}{A (B * theta.dim) matrix containing the posterior distribution for each parameter.}
\item{h.mu}{The sets of parameters found in the optimizer step.}
\item{h.sig}{The covariance matrix for each set of parameters in h.mu.}
\item{log.like}{A vector of likelihoods for the prior plus resamples.}
\item{log.like.0}{A vector of the likelihoods for the prior.}
\item{wts.0}{A vector of importance weights for each set of parameters in the prior.}
\item{d.keep}{The number of optimizer runs where the likelihood exceeded the maximum likelihood of the prior.}
\item{vwts}{A vector containing the variance of the rescaled weights at each IMIS iteration.}
\item{ewts}{A vector containing the entropy of the rescaled weights at each IMIS iteration.}
\item{mwts}{A vector containing the maximum of the rescaled weights at each IMIS iteration.}
\item{mwt.case}{The maximum weight and associated case.}
\item{nup}{A vector containing the expected number of unique points at each IMIS iteration.}
\item{frac.up}{A vector containing the proportion of unique points in the final resample at each IMIS iteration.}
\item{wts.k}{A vector containing the importance weights for the final IMIS iteration.}
}
\description{
Runs all the necessary functions to estimate the nine adapted Heligman-Pollard parameters in one step via
Bayesian Melding with IMIS and optimization. In this order and with the proper arguments imputed
the functions run are \link{loop.optim}, \link{samp.postopt}, \link{like.resamp}, \link{final.resamp}.
}
\details{
All age classes are used for adjustment, in case of whish to remove any of the first age classes due to bias in the sample, indicate it with the parameter "rm" and these will be removed starting from the first age class
}
\note{
Because there are multiple sampling steps sometimes with upper and lower bound restricitions, this function can take several minutes to run depending on the sample size, K.
}
\references{
Heligman, L. and Pollard, J.H. (1980) The Age Pattern of Mortality. Journal of the Institute of Actuaries 107:49–80.

Poole, D. and Raftery, A. (2000). Inference for Deterministic Simulation Models: The Bayesian Melding Approach. Journal of the American Statistical Association 95:1244–1255.

Raftery, A. and Bao, L. (2009). Estimating and Projecting Trends in HIV/AIDS Generalized Epidemics Using Incremental Mixture Importance Sampling. Technical Report 560, Department of Statistics, University of Washington.

Sharrow, D.J., Clark, S.J., Collinson, M.A., Kahn, K. and Tollman, S.M. (2013). The Age Pattern of Increases in Mortality Affected by HIV: Bayesian Fit of the Heligman-Pollard Model to Data from the Agincourt HDSS Field Site in Rural Northeast South Africa. Demogr. Res. 29, 1039–1096.
}
\seealso{
\link{loop.optim} \link{samp.postopt} \link{like.resamp} \link{final.resamp}
}
\keyword{Heligman-Pollard}
\keyword{bycatch}
\keyword{mortality}
