% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HP.mod.R
\name{samp.postopt}
\alias{samp.postopt}
\title{Multivariate Gaussian Sampling for Heligman-Pollard model estimated via Bayesian Melding.}
\usage{
samp.postopt(opt.cov.d, opt.mu.d, d.keep, prior, B = 400, B0 = 8000,
  d = 10)
}
\arguments{
\item{opt.cov.d}{An array containing a covariance matrix for each run of optimizer where the likelihood for that run exceeds the maximum likelihood from the prior.}

\item{opt.mu.d}{A matrix containing the results of the optimizer step.}

\item{d.keep}{Number of runs of optimizer where the likelihood for that run exceeds the maximum likelihood from the prior.}

\item{prior}{A matrix containing the prior distribution (see \link{HP.priors}).}

\item{B}{Sample size at the importance sampling stage.}

\item{B0}{Sample size of the prior. This is equal to (theta.dim * 1000).}

\item{d}{Number of optimizer iterations.}
}
\value{
\item{H.k}{The prior plus new samples.}
\item{H.new}{The new samples from the multivariate normal.}
\item{B1}{The number of new samples - should be equal to B * d.keep.}
}
\description{
Samples the nine Heligman-Pollard parameters from the mvnorm distribution for each run of optimizer step where the likelihood for that run exceeds the maximum likelihood from the prior.
}
\note{
For use within the function \link{HP.mod}.
}
\references{
Heligman, L. and Pollard, J.H. (1980) The Age Pattern of Mortality. Journal of the Institute of Actuaries 107:49-80.

Poole, D and Raftery, A. (2000). Inference for Deterministic Simulation Models: The Bayesian Melding Approach. Journal of the American Statistical Association 95:1244-1255.

Raftery, A and Bao, L. (2009). "Estimating and Projecting Trends in HIV/AIDS Generalized Epidemics Using Incremental Mixture Importance Sampling." Technical Report 560, Department of Statistics, University of Washington.

Sharrow, D.J., Clark, S.J., Collinson, M.A., Kahn, K. and Tollman, S.M. (2013). The Age Pattern of Increases in Mortality Affected by HIV: Bayesian Fit of the Heligman-Pollard Model to Data from the Agincourt HDSS Field Site in Rural Northeast South Africa. Demogr. Res. 29, 1039–1096.
}
\keyword{Heligman-Pollard}
\keyword{bycatch}
\keyword{mortality}
\keyword{post-sampling}
