% Generated by roxygen2 (4.0.2): do not edit by hand
\name{theta}
\alias{theta}
\title{Theta}
\usage{
theta(g)
}
\arguments{
\item{g}{a \code{\link{gtypes}} object.}
}
\value{
vector of theta values for each locus.
}
\description{
Calculate theta from heterozygosity of each locus.
}
\details{
Calculates theta for each locus using the \code{\link[pegas]{theta.h}} function.
}
\examples{
data(dolph.strata)
data(dolph.msats)
msat.merge <- merge(dolph.strata, dolph.msats, by = "ids", all.y = TRUE, sort = FALSE)
msats <- gtypes(msat.merge, id.col = 1, strata.col = 3, locus.col = 5)
theta(msats)
}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}

