% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/stat.fst.R
\name{stat.fst}
\alias{stat.fst}
\title{Fst Analysis of Population Structure}
\usage{
stat.fst(g)
}
\arguments{
\item{g}{a \code{gtypes} object.}
}
\value{
a \code{\link{gtype.struct.stat}} list with the Fst estimate.
}
\description{
Fst Analysis of Population Structure
}
\examples{
data(dolph.strata)
data(dolph.msats)
msat.merge <- merge(dolph.strata, dolph.msats, by = "ids", all.y = TRUE, sort = FALSE)
msats <- gtypes(msat.merge, id.col = 1, strata.col = 3, locus.col = 5, description = "msats")

stat.fst(msats)
}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}
\references{
Weir, B.S., Cockerham, C.C. 1984. Estimating F-statistics
 for the analysis of population structure. Evolution 38(6):1358-1370.
}

