% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/summarize.loci.R
\name{summarize.loci}
\alias{summarize.loci}
\title{Locus Summaries}
\usage{
summarize.loci(g, analyses = NULL, ...)
}
\arguments{
\item{g}{a \code{\link{gtypes}} object.}

\item{analyses}{character vector specifying analyses to include in summary.
Can contain "num.alleles", "num.missing", "prop.missing", "allelic.richness", "exptd.het", "obsvd.het", "theta", "hwe.p".
For all available, use "all". Default of \code{NULL} produces all analyses but "hwe.p".}

\item{...}{arguments to be passed on to analysis functions.}
}
\value{
A list with data.frames of locus summary statistics for each stratum with one row per loci.
  The final element in the list, "All", summarizes loci across all individuals in \code{g}.
}
\description{
Compile standard set of by-locus summaries for diploid data.
}
\examples{
data(dolph.strata)
data(dolph.msats)
msat.merge <- merge(dolph.strata, dolph.msats, by = "ids", all.y = TRUE, sort = FALSE)
msats <- gtypes(msat.merge, id.col = 1, strata.col = 3, locus.col = 5, description = "msats")

summarize.loci(msats)
}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}
\seealso{
\code{\link{num.alleles}}, \code{\link{num.missing}},
  \code{\link{allelic.richness}}, \code{\link{exptd.het}} \code{\link{obsvd.het}},
  \code{\link{theta}}, \code{\link{hwe.genepop}}
}

