% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write.arlequin.R
\name{write.arlequin}
\alias{.writeArlequinHeader}
\alias{.writeArlequinMsats}
\alias{.writeArlequinSequences}
\alias{.writeArlequinStructure}
\alias{arlequin}
\alias{write.arlequin}
\title{Write Arlequin Input Files}
\usage{
.writeArlequinHeader(g, file)

.writeArlequinSequences(st, file, locus)

.writeArlequinMsats(st, file)

.writeArlequinStructure(g, file, data.type)

write.arlequin(g, label = NULL, locus = 1)
}
\arguments{
\item{g}{a \linkS4class{gtypes} object.}

\item{locus}{numeric or character designation of which locus to write for 
haploid data.}

\item{label}{label for Arlequin project filename (.arp). If \code{NULL}, the 
gtypes description is used if present.}
}
\description{
Create an Arlequin-formatted input file from a \code{gtypes} object.
}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}
\references{
Excoffier, L.G. Laval, and S. Schneider (2005) 
  Arlequin ver. 3.0: An integrated software package for population genetics 
  data analysis. Evolutionary Bioinformatics Online 1:47-50.\cr
  Available at \url{http://cmpg.unibe.ch/software/arlequin3/}
}
\keyword{internal}

