% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gtypes2phyDat.R
\name{gtypes2phyDat}
\alias{gtypes2phyDat}
\alias{phyDat2gtypes}
\title{Convert Between \code{gtypes} And \code{phyDat} objects.}
\usage{
gtypes2phyDat(x, locus = 1)

phyDat2gtypes(x, ...)
}
\arguments{
\item{x}{a \linkS4class{gtypes} or \code{phyDat} formatted object.}

\item{locus}{name or number of locus to convert.}

\item{...}{optional arguments passed to \code{\link{sequence2gtypes}}.}
}
\description{
Convert a \code{gtypes} object to a \code{\link[phangorn]{phyDat}} object.
}
\examples{
data(dloop.g)

# Convert to phDat
pd <- gtypes2phyDat(dloop.g)
pd

# Convert to gtypes
gt <- phyDat2gtypes(pd)
gt 

}
\seealso{
\link{initialize.gtypes}, \link{df2gtypes}, 
  \link{sequence2gtypes}, \link{as.data.frame.gtypes}, 
  \link{gtypes2genind}, \link{gtypes2loci}
}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}
