% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gtypes.class.R
\docType{class}
\name{gtypes-class}
\alias{gtypes-class}
\alias{gtypes}
\title{\code{gtypes} Class}
\description{
An S4 class storing multi-allelic locus or sequence data along
  with a current stratification and option stratification schemes.
}
\section{Slots}{

\describe{
\item{\code{data}}{a data.table where the first column contains the sample ID 
(\code{ids}). The second column contains the sample stratification 
(\code{strata}). The third column to the end contains the allelic data as 
one column per locus. Alleles are on multiple rows per column with sample 
IDs duplicated for all alleles. Column names are unique locus names.}

\item{\code{sequences}}{a \linkS4class{multidna} object.}

\item{\code{ploidy}}{integer representing the ploidy of the data. There are
ploidy * the number of individuals rows in 'data'.}

\item{\code{schemes}}{a data.frame with stratification schemes in each column.
The rownames are individual names and must match the 'id' column of the
'data' slot. Each column is a factor.}

\item{\code{description}}{a label for the object (optional).}

\item{\code{other}}{a slot to carry other related information - currently unused in 
analyses (optional).}
}}

\examples{

#--- create a diploid (microsatellite) gtypes object
data(dolph.msats)
data(dolph.strata)
strata.schemes <- dolph.strata[, c("broad", "fine")]
rownames(strata.schemes) <- dolph.strata$id
msats.g <- new("gtypes", gen.data = dolph.msats[, -1], ploidy = 2,
               ind.names = dolph.msats[, 1], schemes = strata.schemes)
msats.g

#--- create a haploid sequence (mtDNA) gtypes object and label haplotypes
data(dolph.seqs)
dloop.haps <- cbind(dLoop = dolph.strata$id)
rownames(dloop.haps) <- dolph.strata$id
dloop.g <- new("gtypes", gen.data = dloop.haps, ploidy = 1, 
               schemes = strata.schemes, sequences = dolph.seqs, 
               strata = "fine")
dloop.g
labelHaplotypes(dloop.g, "Hap.")

}
\seealso{
\code{\link{df2gtypes}}, \code{\link{sequence2gtypes}},
  \code{\link{gtypes.accessors}}, \code{\link{gtypes.initialize}}
}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}
