% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{sugarcane}
\alias{sugarcane}
\title{Sugarcane Farming Data in Fiji}
\format{A data frame with 13894 observations corresponding to individual farms.
The following are the variables:

\describe{
\item{\code{DispArea}}{Disposition area (or land area under cane) (hactares)}
\item{\code{Production}}{The amount of sugarcane produced in the farm (tonnes)}
\item{\code{Income}}{Net income or money paid to farmers) (in FJD)}}}
\source{
This data was obtained from the Fiji Sugar Corporation in Fiji.
}
\usage{
data(sugarcane)
}
\description{
The sugarcane data shows the disposition area (land
area under cane) for individual sugarcane farms
and their cane productions with the incomes/earnings
for the year 2010 in Fiji.
}
\examples{
data(sugarcane$Production)
head(sugarcane$Production)
Production <- sugarcane$Production
min(Production); max(Production)
hist(Production)
boxplot(Production)

}
\keyword{datasets}
