% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EVP.R
\name{EVP}
\alias{EVP}
\title{Optimization Algorithm to solve stratification problem}
\usage{
EVP(X, L, cv, nhmin = 1, Nmin = 2, imax = 150, tmax = 7, pmax = 5,
  notbest = 25, range_s = 30, range_b = 20, cpu_time = 5000,
  cores = 2)
}
\arguments{
\item{X}{Values of the population associated with stratification variable.}

\item{L}{Number of strata.}

\item{cv}{Value with target cv associated with stratification variable, between 0 and 1.}

\item{nhmin}{Smallest possible sample size in any stratum. The default is 1.}

\item{Nmin}{Smallest possible population size in any stratum. The default is 2.}

\item{imax}{Maximum number of iterations. The default is 150.}

\item{tmax}{Maximum number neighbors. The default is 7.}

\item{pmax}{Maximum number of solutions - pool. The default is 5.}

\item{notbest}{Maximum number of iterations without improvement. The default is 25.}

\item{range_s}{Shaking interval. The default is 30.}

\item{range_b}{Search interval. The default is 20.}

\item{cpu_time}{Maximum cpu time. The default is 5000.}

\item{cores}{Numerical amount of CPUs requested for the cluster. The default is 2.}
}
\value{
\item{TYPE}{Type of solution. If the solution was obtained by the exact method
                   returns "GLOBAL OPTIMA" else the solution was obtained by the metaheuristic
                    method returns "LOCAL OPTIMA".}

\item{bh}{Strata boundaries.}

\item{Nh}{Population size in each stratum.}

\item{n}{Total sample size.}

\item{nh}{Sample size in each stratum.The last one is a take-all stratum, then sample size
                 equal to population size.}

\item{cv}{Estimated coefficient of variation for the estimator of total of the stratification variable.}

\item{cputime}{Time consumed by the algorithm in seconds.}
}
\description{
An Optimization Algorithm Applied to Univariate Stratification Problem.
It's aims to delimit the population strata and defining the allocation of sample,
considering  the following objective: minimize the sample size given a fixed precision level.
Exhaustive enumeration method is applied in small problems, while in problems with greater
complexity the algorithm is based on metaheuristics Variable Neighborhood Decomposition
Search with Path-Relinking.
}
\examples{
data(Sweden)
P75<-Sweden[,3]
solution1<-EVP(P75,L=2,cv=0.1,nhmin=5,imax=50,cores=2)
solution2<-EVP(P75,L=6,cv=0.1,cores=2,imax=25)
}
\references{
Brito, J.A.M, Silva, P.L.N.,Semaan, G.S. and Maculan, N. (2015).
           Integer Programming Formulations Applied to Optimal Allocation in Stratified Sampling.
           Survey Methodology, 41: 427-442.

           Brito, J.A.M, Semaan, G.S., Fadel, A.C. and Brito, L.R.(2017).
           An optimization approach applied to the optimal stratification problem,
           Communications in Statistics - Simulation and Computation.

          Hansen, P.; Mladenovic, N.; Perez-Brito, D. (2001).
          Variable Neighborhood Decomposition Search.
          Journal of Heuristics 7.4, pp. 335-350.

          Glover, F.; Kochenberger, G. A., eds. (2003).
         Handbook of Metaheuristics. Springer.
}
\author{
Breno Trotta de Oliveira(brenotrotta@yahoo.com.br), Leonardo Lima and Jose Brito.
}
