/*
 * Decompiled with CFR 0.152.
 */
package moa.clusterers.streamkm;

import moa.clusterers.streamkm.MTRandom;
import moa.clusterers.streamkm.Point;
import moa.clusterers.streamkm.TreeCoreset;

public class BucketManager {
    protected int numberOfBuckets;
    protected int maxBucketsize;
    protected Bucket[] buckets;
    protected MTRandom clustererRandom;
    protected TreeCoreset treeCoreset;

    public BucketManager(int n, int d, int maxsize, MTRandom random) {
        this.clustererRandom = random;
        this.numberOfBuckets = (int)Math.ceil(Math.log((double)n / (double)maxsize) / Math.log(2.0)) + 2;
        this.maxBucketsize = maxsize;
        this.buckets = new Bucket[this.numberOfBuckets];
        for (int i = 0; i < this.numberOfBuckets; ++i) {
            this.buckets[i] = new Bucket(d, maxsize);
        }
        this.treeCoreset = new TreeCoreset();
    }

    void insertPoint(Point p) {
        int cursize = this.buckets[0].cursize;
        if (cursize >= this.maxBucketsize) {
            int curbucket = 0;
            int nextbucket = 1;
            if (this.buckets[nextbucket].cursize == 0) {
                for (int i = 0; i < this.maxBucketsize; ++i) {
                    this.buckets[nextbucket].points[i] = this.buckets[curbucket].points[i].clone();
                }
                this.buckets[nextbucket].cursize = this.maxBucketsize;
                this.buckets[curbucket].cursize = 0;
                cursize = 0;
            } else {
                for (int i = 0; i < this.maxBucketsize; ++i) {
                    this.buckets[nextbucket].spillover[i] = this.buckets[curbucket].points[i].clone();
                }
                this.buckets[0].cursize = 0;
                cursize = 0;
                ++curbucket;
                ++nextbucket;
                while (this.buckets[nextbucket].cursize == this.maxBucketsize) {
                    this.treeCoreset.unionTreeCoreset(this.maxBucketsize, this.maxBucketsize, this.maxBucketsize, p.dimension, this.buckets[curbucket].points, this.buckets[curbucket].spillover, this.buckets[nextbucket].spillover, this.clustererRandom);
                    this.buckets[curbucket].cursize = 0;
                    ++curbucket;
                    ++nextbucket;
                }
                this.treeCoreset.unionTreeCoreset(this.maxBucketsize, this.maxBucketsize, this.maxBucketsize, p.dimension, this.buckets[curbucket].points, this.buckets[curbucket].spillover, this.buckets[nextbucket].points, this.clustererRandom);
                this.buckets[curbucket].cursize = 0;
                this.buckets[nextbucket].cursize = this.maxBucketsize;
            }
        }
        this.buckets[0].points[cursize] = p.clone();
        ++this.buckets[0].cursize;
    }

    Point[] getCoresetFromManager(int d) {
        Point[] coreset = new Point[d];
        int i = 0;
        if (this.buckets[this.numberOfBuckets - 1].cursize == this.maxBucketsize) {
            coreset = this.buckets[this.numberOfBuckets - 1].points;
        } else {
            for (i = 0; i < this.numberOfBuckets; ++i) {
                if (this.buckets[i].cursize == 0) continue;
                coreset = this.buckets[i].points;
                break;
            }
            for (int j = i + 1; j < this.numberOfBuckets; ++j) {
                if (this.buckets[j].cursize == 0) continue;
                this.treeCoreset.unionTreeCoreset(this.maxBucketsize, this.maxBucketsize, this.maxBucketsize, d, this.buckets[j].points, coreset, this.buckets[j].spillover, this.clustererRandom);
                coreset = this.buckets[j].spillover;
            }
        }
        return coreset;
    }

    protected class Bucket {
        int cursize = 0;
        Point[] points;
        Point[] spillover;

        public Bucket(int d, int maxsize) {
            this.points = new Point[maxsize];
            this.spillover = new Point[maxsize];
            for (int i = 0; i < maxsize; ++i) {
                this.points[i] = new Point(d);
                this.spillover[i] = new Point(d);
            }
        }
    }
}

