/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import java.text.SimpleDateFormat;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Range;
import weka.core.RevisionUtils;
import weka.core.SelectedTag;
import weka.core.SingleIndex;
import weka.core.Tag;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.StreamableFilter;
import weka.filters.UnsupervisedFilter;

public class Add
extends Filter
implements UnsupervisedFilter,
StreamableFilter,
OptionHandler {
    static final long serialVersionUID = 761386447332932389L;
    public static final Tag[] TAGS_TYPE = new Tag[]{new Tag(0, "NUM", "Numeric attribute"), new Tag(1, "NOM", "Nominal attribute"), new Tag(2, "STR", "String attribute"), new Tag(3, "DAT", "Date attribute")};
    protected int m_AttributeType = 0;
    protected String m_Name = "unnamed";
    private SingleIndex m_Insert = new SingleIndex("last");
    protected FastVector m_Labels = new FastVector();
    protected String m_DateFormat = "yyyy-MM-dd'T'HH:mm:ss";

    public String globalInfo() {
        return "An instance filter that adds a new attribute to the dataset. The new attribute will contain all missing values.";
    }

    @Override
    public Enumeration listOptions() {
        Vector<Option> newVector = new Vector<Option>();
        String desc = "";
        for (int i = 0; i < TAGS_TYPE.length; ++i) {
            SelectedTag tag = new SelectedTag(TAGS_TYPE[i].getID(), TAGS_TYPE);
            desc = desc + "\t" + tag.getSelectedTag().getIDStr() + " = " + tag.getSelectedTag().getReadable() + "\n";
        }
        newVector.addElement(new Option("\tThe type of attribute to create:\n" + desc + "\t(default: " + new SelectedTag(0, TAGS_TYPE) + ")", "T", 1, "-T " + Tag.toOptionList((Tag[])TAGS_TYPE)));
        newVector.addElement(new Option("\tSpecify where to insert the column. First and last\n\tare valid indexes.(default: last)", "C", 1, "-C <index>"));
        newVector.addElement(new Option("\tName of the new attribute.\n\t(default: 'Unnamed')", "N", 1, "-N <name>"));
        newVector.addElement(new Option("\tCreate nominal attribute with given labels\n\t(default: numeric attribute)", "L", 1, "-L <label1,label2,...>"));
        newVector.addElement(new Option("\tThe format of the date values (see ISO-8601)\n\t(default: yyyy-MM-dd'T'HH:mm:ss)", "F", 1, "-F <format>"));
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String tmpStr = Utils.getOption('T', options);
        if (tmpStr.length() != 0) {
            this.setAttributeType(new SelectedTag(tmpStr, TAGS_TYPE));
        } else {
            this.setAttributeType(new SelectedTag(0, TAGS_TYPE));
        }
        tmpStr = Utils.getOption('C', options);
        if (tmpStr.length() == 0) {
            tmpStr = "last";
        }
        this.setAttributeIndex(tmpStr);
        this.setAttributeName(Utils.unbackQuoteChars(Utils.getOption('N', options)));
        if (this.m_AttributeType == 1) {
            tmpStr = Utils.getOption('L', options);
            if (tmpStr.length() != 0) {
                this.setNominalLabels(tmpStr);
            }
        } else if (this.m_AttributeType == 3 && (tmpStr = Utils.getOption('F', options)).length() != 0) {
            this.setDateFormat(tmpStr);
        }
        if (this.getInputFormat() != null) {
            this.setInputFormat(this.getInputFormat());
        }
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        if (this.m_AttributeType != 0) {
            result.add("-T");
            result.add("" + this.getAttributeType());
        }
        result.add("-N");
        result.add(Utils.backQuoteChars(this.getAttributeName()));
        if (this.m_AttributeType == 1) {
            result.add("-L");
            result.add(this.getNominalLabels());
        } else if (this.m_AttributeType == 1) {
            result.add("-F");
            result.add(this.getDateFormat());
        }
        result.add("-C");
        result.add("" + this.getAttributeIndex());
        return result.toArray(new String[result.size()]);
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enableAllAttributes();
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enableAllClasses();
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.enable(Capabilities.Capability.NO_CLASS);
        return result;
    }

    @Override
    public boolean setInputFormat(Instances instanceInfo) throws Exception {
        super.setInputFormat(instanceInfo);
        this.m_Insert.setUpper(instanceInfo.numAttributes());
        Instances outputFormat = new Instances(instanceInfo, 0);
        Attribute newAttribute = null;
        switch (this.m_AttributeType) {
            case 0: {
                newAttribute = new Attribute(this.m_Name);
                break;
            }
            case 1: {
                newAttribute = new Attribute(this.m_Name, this.m_Labels);
                break;
            }
            case 2: {
                newAttribute = new Attribute(this.m_Name, (List<String>)null);
                break;
            }
            case 3: {
                newAttribute = new Attribute(this.m_Name, this.m_DateFormat);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown attribute type in Add");
            }
        }
        if (this.m_Insert.getIndex() < 0 || this.m_Insert.getIndex() > this.getInputFormat().numAttributes()) {
            throw new IllegalArgumentException("Index out of range");
        }
        outputFormat.insertAttributeAt(newAttribute, this.m_Insert.getIndex());
        this.setOutputFormat(outputFormat);
        Range atts = new Range(this.m_Insert.getSingleIndex());
        atts.setInvert(true);
        atts.setUpper(outputFormat.numAttributes() - 1);
        this.initOutputLocators(outputFormat, atts.getSelection());
        return true;
    }

    @Override
    public boolean input(Instance instance) {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_NewBatch) {
            this.resetQueue();
            this.m_NewBatch = false;
        }
        Instance inst = (Instance)instance.copy();
        this.copyValues(inst, true, inst.dataset(), this.getOutputFormat());
        inst.setDataset(null);
        inst.insertAttributeAt(this.m_Insert.getIndex());
        inst.setDataset(this.getOutputFormat());
        this.push(inst);
        return true;
    }

    public String attributeNameTipText() {
        return "Set the new attribute's name.";
    }

    public String getAttributeName() {
        return this.m_Name;
    }

    public void setAttributeName(String name) {
        this.m_Name = name.trim().equals("") ? "unnamed" : name;
    }

    public String attributeIndexTipText() {
        return "The position (starting from 1) where the attribute will be inserted (first and last are valid indices).";
    }

    public String getAttributeIndex() {
        return this.m_Insert.getSingleIndex();
    }

    public void setAttributeIndex(String attIndex) {
        this.m_Insert.setSingleIndex(attIndex);
    }

    public String nominalLabelsTipText() {
        return "The list of value labels (nominal attribute creation only).  The list must be comma-separated, eg: \"red,green,blue\". If this is empty, the created attribute will be numeric.";
    }

    public String getNominalLabels() {
        String labelList = "";
        for (int i = 0; i < this.m_Labels.size(); ++i) {
            labelList = i == 0 ? (String)this.m_Labels.elementAt(i) : labelList + "," + (String)this.m_Labels.elementAt(i);
        }
        return labelList;
    }

    public void setNominalLabels(String labelList) {
        String label;
        int commaLoc;
        FastVector<String> labels = new FastVector<String>(10);
        while ((commaLoc = labelList.indexOf(44)) >= 0) {
            label = labelList.substring(0, commaLoc).trim();
            if (label.equals("")) {
                throw new IllegalArgumentException("Invalid label list at " + labelList.substring(commaLoc));
            }
            labels.addElement(label);
            labelList = labelList.substring(commaLoc + 1);
        }
        label = labelList.trim();
        if (!label.equals("")) {
            labels.addElement(label);
        }
        this.m_Labels = labels;
        this.m_AttributeType = labels.size() == 0 ? 0 : 1;
    }

    public String attributeTypeTipText() {
        return "Defines the type of the attribute to generate.";
    }

    public void setAttributeType(SelectedTag value) {
        if (value.getTags() == TAGS_TYPE) {
            this.m_AttributeType = value.getSelectedTag().getID();
        }
    }

    public SelectedTag getAttributeType() {
        return new SelectedTag(this.m_AttributeType, TAGS_TYPE);
    }

    public String dateFormatTipText() {
        return "The format of the date values (see ISO-8601).";
    }

    public String getDateFormat() {
        return this.m_DateFormat;
    }

    public void setDateFormat(String value) {
        try {
            new SimpleDateFormat(value);
            this.m_DateFormat = value;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5987 $");
    }

    public static void main(String[] argv) {
        Add.runFilter(new Add(), argv);
    }
}

