/*
 * Decompiled with CFR 0.152.
 */
package moa.core;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;

public class TimingUtils {
    protected static boolean preciseThreadTimesAvailable = false;

    public static boolean enablePreciseTiming() {
        if (!preciseThreadTimesAvailable) {
            try {
                ThreadMXBean tmxb = ManagementFactory.getThreadMXBean();
                if (tmxb.isCurrentThreadCpuTimeSupported()) {
                    tmxb.setThreadCpuTimeEnabled(true);
                    preciseThreadTimesAvailable = true;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return preciseThreadTimesAvailable;
    }

    public static long getNanoCPUTimeOfCurrentThread() {
        return TimingUtils.getNanoCPUTimeOfThread(Thread.currentThread().getId());
    }

    public static long getNanoCPUTimeOfThread(long threadID) {
        long time;
        if (preciseThreadTimesAvailable && (time = ManagementFactory.getThreadMXBean().getThreadCpuTime(threadID)) != -1L) {
            return time;
        }
        return System.nanoTime();
    }

    public static double nanoTimeToSeconds(long nanoTime) {
        return (double)nanoTime / 1.0E9;
    }
}

