/*
 * Decompiled with CFR 0.152.
 */
package moa.streams.generators;

import com.github.javacliparser.IntOption;
import com.yahoo.labs.samoa.instances.DenseInstance;
import com.yahoo.labs.samoa.instances.InstancesHeader;
import moa.core.InstanceExample;
import moa.core.ObjectRepository;
import moa.streams.generators.LEDGenerator;
import moa.tasks.TaskMonitor;

public class LEDGeneratorDrift
extends LEDGenerator {
    private static final long serialVersionUID = 1L;
    public IntOption numberAttributesDriftOption = new IntOption("numberAttributesDrift", 'd', "Number of attributes with drift.", 1, 0, 7);
    protected int[] numberAttribute;

    @Override
    public String getPurposeString() {
        return "Generates a problem of predicting the digit displayed on a 7-segment LED display with drift.";
    }

    @Override
    protected void prepareForUseImpl(TaskMonitor monitor, ObjectRepository repository) {
        super.prepareForUseImpl(monitor, repository);
        this.numberAttribute = new int[24];
        for (int i = 0; i < 24; ++i) {
            this.numberAttribute[i] = i;
        }
        if (!this.suppressIrrelevantAttributesOption.isSet() && this.numberAttributesDriftOption.getValue() > 0) {
            int randomInt = 0;
            int offset = 0;
            for (int i = 0; i < this.numberAttributesDriftOption.getValue(); ++i) {
                int value2;
                int value1 = (i + randomInt) % 7;
                this.numberAttribute[value1] = value2 = 7 + (i + offset) % 17;
                this.numberAttribute[value2] = value1;
            }
        }
    }

    @Override
    public InstanceExample nextInstance() {
        int i;
        InstancesHeader header = this.getHeader();
        DenseInstance inst = new DenseInstance((double)header.numAttributes());
        inst.setDataset(header);
        int selected = this.instanceRandom.nextInt(10);
        for (i = 0; i < 7; ++i) {
            if (1 + this.instanceRandom.nextInt(100) <= this.noisePercentageOption.getValue()) {
                inst.setValue(this.numberAttribute[i], originalInstances[selected][i] == 0 ? 1.0 : 0.0);
                continue;
            }
            inst.setValue(this.numberAttribute[i], (double)originalInstances[selected][i]);
        }
        if (!this.suppressIrrelevantAttributesOption.isSet()) {
            for (i = 0; i < 17; ++i) {
                inst.setValue(this.numberAttribute[i + 7], (double)this.instanceRandom.nextInt(2));
            }
        }
        inst.setClassValue(selected);
        return new InstanceExample(inst);
    }

    @Override
    public void getDescription(StringBuilder sb, int indent) {
    }
}

