/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.trees.iadem;

import com.yahoo.labs.samoa.instances.Instance;
import moa.classifiers.core.driftdetection.AbstractChangeDetector;
import moa.classifiers.trees.iadem.Iadem2;
import moa.classifiers.trees.iadem.Iadem3;
import moa.classifiers.trees.iadem.IademException;
import moa.classifiers.trees.iadem.IademNumericAttributeObserver;

public class Iadem3Subtree
extends Iadem3 {
    protected static final long serialVersionUID = 1L;
    protected AbstractChangeDetector errorEstimator;
    protected Iadem2.Node nodo;
    protected Iadem3 mainTree;

    public Iadem3Subtree(Iadem2.Node node, int treeLevel, Iadem3 mainTree, Instance instance) {
        this.numericEstimatorOption.setValueViaCLIString(mainTree.numericEstimatorOption.getValueAsCLIString());
        this.gracePeriodOption.setValue(mainTree.gracePeriodOption.getValue());
        this.splitCriterionOption.setChosenIndex(mainTree.splitCriterionOption.getChosenIndex());
        this.splitConfidenceOption.setValue(mainTree.splitConfidenceOption.getValue());
        this.splitTestsOption.setChosenIndex(mainTree.splitTestsOption.getChosenIndex());
        this.leafPredictionOption.setChosenIndex(mainTree.leafPredictionOption.getChosenIndex());
        this.driftDetectionMethodOption.setValueViaCLIString(mainTree.driftDetectionMethodOption.getValueAsCLIString());
        this.attributeDiferentiation.setValue(mainTree.attributeDiferentiation.getValue());
        this.maxNestingLevelOption.setValue(mainTree.maxNestingLevelOption.getValue());
        this.maxSubtreesPerNodeOption.setValue(mainTree.maxSubtreesPerNodeOption.getValue());
        this.estimator = mainTree.getEstimatorCopy();
        this.errorEstimator = mainTree.getEstimatorCopy();
        this.nodo = node;
        this.mainTree = mainTree;
        this.mainTree.updateNumberOfLeaves(1);
        this.mainTree.updateNumberOfNodes(1);
        this.createRoot(instance);
    }

    @Override
    public AbstractChangeDetector getEstimatorCopy() {
        return this.mainTree.getEstimatorCopy();
    }

    @Override
    protected IademNumericAttributeObserver newNumericClassObserver() {
        return this.mainTree.newNumericClassObserver();
    }

    @Override
    public void learnFromInstance(Instance instance) throws IademException {
        this.getClassVotes(instance);
        this.getClassVotesFromLeaf(instance);
        boolean rightPredicted = (double)this.lastPredictionInLeaf == instance.classValue();
        double lossValue = rightPredicted ? 0.0 : 1.0;
        this.errorEstimator.input(lossValue);
        this.treeRoot.learnFromInstance(instance);
    }

    @Override
    public boolean canCreateSubtree() {
        return this.mainTree.canCreateSubtree();
    }

    public double estimacionValorMedio() {
        return this.errorEstimator != null ? this.errorEstimator.getEstimation() : -1.0;
    }

    public int windowWidth() {
        return (int)(this.errorEstimator != null ? this.errorEstimator.getDelay() : 0.0);
    }

    public AbstractChangeDetector getEstimador() {
        return this.errorEstimator;
    }

    public void setEstimador(AbstractChangeDetector estimador) {
        this.errorEstimator = estimador;
    }

    @Override
    public void setNewTree() {
        ((Iadem3)this.nodo.getTree()).setNewTree();
    }

    @Override
    public void newDeletedTree() {
        ((Iadem3)this.nodo.getTree()).newDeletedTree();
    }

    @Override
    public void newTreeChange() {
        ((Iadem3)this.nodo.getTree()).newTreeChange();
    }

    @Override
    protected Iadem3 getMainTree() {
        return this.mainTree;
    }

    @Override
    public void newSplit(int numOfLeaves) {
        this.numberOfLeaves += numOfLeaves - 1;
        this.numberOfNodes += numOfLeaves;
        this.mainTree.newSplit(numOfLeaves);
    }

    @Override
    public void updateNumberOfLeaves(int amount) {
        this.numberOfLeaves += amount;
        this.mainTree.updateNumberOfLeaves(amount);
    }

    @Override
    public void updateNumberOfNodes(int amount) {
        this.numberOfNodes += amount;
        this.mainTree.updateNumberOfNodes(amount);
    }

    @Override
    public void updateNumberOfNodesSplitByTieBreaking(int amount) {
        this.numSplitsByBreakingTies += amount;
        this.mainTree.updateNumberOfNodesSplitByTieBreaking(amount);
    }

    @Override
    public void addSubtree(Iadem3Subtree subtree) {
        this.mainTree.addSubtree(subtree);
    }

    @Override
    public void removeSubtree(Iadem3Subtree subtree) {
        this.mainTree.removeSubtree(subtree);
    }
}

