/*
 * Decompiled with CFR 0.152.
 */
package moa.core;

import java.text.DecimalFormat;

public class StringUtils {
    public static final String newline = System.getProperty("line.separator");

    public static String doubleToString(double value, int fractionDigits) {
        return StringUtils.doubleToString(value, 0, fractionDigits);
    }

    public static String doubleToString(double value, int minFractionDigits, int maxFractionDigits) {
        DecimalFormat numberFormat = new DecimalFormat();
        numberFormat.setMinimumFractionDigits(minFractionDigits);
        numberFormat.setMaximumFractionDigits(maxFractionDigits);
        return numberFormat.format(value);
    }

    public static void appendNewline(StringBuilder out) {
        out.append(newline);
    }

    public static void appendIndent(StringBuilder out, int indent) {
        for (int i = 0; i < indent; ++i) {
            out.append(' ');
        }
    }

    public static void appendIndented(StringBuilder out, int indent, String s) {
        StringUtils.appendIndent(out, indent);
        out.append(s);
    }

    public static void appendNewlineIndented(StringBuilder out, int indent, String s) {
        StringUtils.appendNewline(out);
        StringUtils.appendIndented(out, indent, s);
    }

    public static String secondsToDHMSString(double seconds) {
        if (seconds < 60.0) {
            return StringUtils.doubleToString(seconds, 2, 2) + 's';
        }
        long secs = (int)seconds;
        long mins = secs / 60L;
        long hours = mins / 60L;
        long days = hours / 24L;
        secs %= 60L;
        mins %= 60L;
        hours %= 24L;
        StringBuilder result = new StringBuilder();
        if (days > 0L) {
            result.append(days);
            result.append('d');
        }
        if (hours > 0L || days > 0L) {
            result.append(hours);
            result.append('h');
        }
        if (hours > 0L || days > 0L || mins > 0L) {
            result.append(mins);
            result.append('m');
        }
        result.append(secs);
        result.append('s');
        return result.toString();
    }
}

