% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DSC_CluStream.R
\name{DSC_CluStream}
\alias{DSC_CluStream}
\alias{DSC_CluStream_MOA}
\alias{CluStream}
\alias{clustream}
\title{CluStream Data Stream Clusterer}
\usage{
DSC_CluStream(m = 100, horizon = 1000, t = 2, k = 5)
}
\arguments{
\item{m}{Defines the maximum number of micro-clusters used in CluStream}

\item{horizon}{Defines the time window to be used in CluStream}

\item{t}{Maximal boundary factor (i.e., the kernel radius factor).  When deciding to
add a new data point to a micro-cluster, the maximum boundary is defined as
a factor of \code{t} of the RMS deviation of the data points in the
micro-cluster from the centroid.}

\item{k}{Number of macro-clusters to produce using weighted k-means.}
}
\value{
An object of class \code{DSC_CluStream} (subclass of
\link{DSC_Micro}, \link{DSC_MOA} and \link{DSC}).
}
\description{
Class implements the CluStream cluster algorithm for data streams (Aggarwal et al, 2003).
}
\details{
This is an interface to the MOA implementation of CluStream.

If \code{k} is specified, then CluStream applies a weighted k-means
algorithm for reclustering (see Examples section below).
}
\examples{
# data with 3 clusters and 5\% noise
set.seed(1000)
stream <- DSD_Gaussians(k = 3, d = 2, noise = .05)

# cluster with CluStream
clustream <- DSC_CluStream(m = 50, horizon = 100, k = 3)
update(clustream, stream, 500)
clustream

plot(clustream, stream, type = "both")
}
\references{
Aggarwal CC, Han J, Wang J, Yu PS (2003). "A Framework for
Clustering Evolving Data Streams." In "Proceedings of the International
Conference on Very Large Data Bases (VLDB '03)," pp. 81-92.

Bifet A, Holmes G, Pfahringer B, Kranen P, Kremer H, Jansen T, Seidl T
(2010). MOA: Massive Online Analysis, a Framework for Stream Classification
and Clustering. In Journal of Machine Learning Research (JMLR).
}
\seealso{
Other DSC_MOA: 
\code{\link{DSC_BICO_MOA}()},
\code{\link{DSC_ClusTree}()},
\code{\link{DSC_DStream_MOA}()},
\code{\link{DSC_DenStream}()},
\code{\link{DSC_MCOD}()},
\code{\link{DSC_MOA}()},
\code{\link{DSC_StreamKM}()}
}
\author{
Michael Hahsler and John Forrest
}
\concept{DSC_MOA}
