% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GenericModelingClasses.R
\docType{class}
\name{CategorModel}
\alias{CategorModel}
\title{R6 class for fitting and predicting joint probability for a univariate categorical summary A[j]}
\format{An \code{\link{R6Class}} generator object}
\usage{
CategorModel
}
\description{
This R6 class defines and fits a conditional probability model \code{P(A[j]|W,...)} for a univariate
 categorical summary measure \code{A[j]}. This class inherits from \code{\link{GenericModel}} class.
 Defines the fitting algorithm for a regression model \code{A[j] ~ W + ...}.
 Reconstructs the likelihood \code{P(A[j]=a[j]|W,...)} afterwards.
 Categorical \code{A[j]} is first redefined into \code{length(levels)} bin indicator variables, where
 \code{levels} is a numeric vector of all unique categories in \code{A[j]}.
 The fitting algorithm estimates the binary regressions for hazard for each bin indicator, \code{Bin_A[j][i] ~ W},
 i.e., the probability that categorical \code{A[j]} falls into bin \code{i}, \code{Bin_A[j]_i},
 given that \code{A[j]} does not fall in any prior bins \code{Bin_A[j]_1, ..., Bin_A[j]_{i-1}}.
 The dataset of bin indicators (\code{BinA[j]_1,...,BinA[j]_M}) is created
 inside the passed \code{data} or \code{newdata} object when defining \code{length(levels)} bins for \code{A[j]}.
}
\details{
\itemize{
\item{\code{reg}} - .
\item{\code{outvar}} - .
\item{\code{levels}} - .
\item{\code{nbins}} - .
}
}
\section{Methods}{

\describe{
  \item{\code{new(reg, DataStorageClass.g0, ...)}}{...}
  \item{\code{fit(data)}}{...}
  \item{\code{predict(newdata)}}{...}
  \item{\code{predictAeqa(newdata)}}{...}
}
}

\section{Active Bindings}{

\describe{
  \item{\code{cats}}{...}
}
}
\keyword{R6}
\keyword{class}

