% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_routines.R
\name{defineIntervedTRT}
\alias{defineIntervedTRT}
\title{Define counterfactual dynamic treatment}
\usage{
defineIntervedTRT(data, theta, ID, t, I, CENS, TRT, MONITOR, tsinceNis1,
  new.TRT.names = NULL, return.allcolumns = FALSE)
}
\arguments{
\item{data}{Input data.frame or data.table in long format, see below for the description of the assumed format.}

\item{theta}{The vector of continuous cutoff values that index each dynamic treatment rule}

\item{ID}{The name of the unique subject identifier}

\item{t}{The name of the variable indicating time-period}

\item{I}{Continuous biomarker variable used for determining the treatmet decision rule}

\item{CENS}{Binary indicator of being censored at t;}

\item{TRT}{Binary indicator of the treatment (exposure) at t;}

\item{MONITOR}{The indicator of having a visit and having measured or observed biomarker I(t+1) (the biomarker value at THE NEXT TIME CYCLE).
In other words the value of MONITOR(t-1) (at t-1) being 1 indicates that I(t) at time point t was observed/measured.
The very first value of I(t) (at the first time-cycle) is ALWAYS ASSUMED observed/measured.}

\item{tsinceNis1}{Character vector for the column in data, same meaning as described in convertdata(), must be already defined}

\item{new.TRT.names}{Vector with names which will be assigned to new columns generated by this routine(must be the same dimension as theta).
When not supplied the following convention is adopted for naming these columns: \code{paste0(TRT,".gstar.","d",theta)}.}

\item{return.allcolumns}{Set to \code{TRUE} to return the original data columns along with new columns that define each rule
(can be useful when employing piping/sequencing operators).}
}
\value{
A data.table with a separate column for each value in \code{theta}. Each column consists of indicators of following/not-following
 each rule indexed by a value form \code{theta}. In addition, the returned data.table contains \code{ID} and \code{t} columns for easy merging
 with the original data.
}
\description{
Defines a new column that contains the counterfactual dynamic treatment values.
Subject is switched to treatment when the biomarker \code{I} crosses the threshold \code{theta} while being monitored \code{MONITOR(t-1)=1}.
}
\section{Details}{


* This function takes an input \code{data.frame} or \code{data.table}
  and produces an output data.table with counterfactual treatment assignment based on a rule defined by values of input column \code{I} and an input scalar \code{theta}.

* Evaluates which observations should have received (switched to) treatment based on dynamic-decision rule defined by the measured biomarker \code{I}
  and pre-defined cutoffs supplied in the vector \code{theta}.

* Produces a separate column for each value in \code{theta}:
\itemize{
\item (1) By default no one is treated (TRT assigned to 0)
\item (2) Subject may switch to treatment the first time \code{I} goes over the threshold \code{theta} (while having been monitored, i.e, MONITOR(t-1)==1)
\item (3) Once the subject switches to treatment he or she has to continue receiving treatment until the end of the follow-up
}

* The format (time-ordering) of data is the same as required by the stremr() function: (I(t), CENS(t), TRT(t), MONITOR(t)).
  MONITOR(t) at time-point t is defined as the indicator of being observed (having an office visit) at time point t+1 (next timepoint after t)
  It is assumed that MONITOR(t) is always 0 for the very first time-point.
}
\examples{

\dontrun{
theta <- seq(7,8.5,by=0.5)
FOLLOW.D.DT <- defineIntervedTRT(data = data, theta = theta,
                 ID = "StudyID", t = "X_intnum", I = "X_a1c",
                 TRT = "X_exposure", CENS = "X_censor", MONITOR = "N.t",
                 new.TRT.names = paste0("gstar",theta))
}
#-------------------------------------------------------------------
# EXAMPLE BASED ON SIMULATED DATA
#-------------------------------------------------------------------
require("data.table")
require("magrittr")
data(OdataCatCENS)
OdataDT <- as.data.table(OdataCatCENS, key=c(ID, t))

#-------------------------------------------------------------------
# Define the counterfactual dynamic treatment assignment
#-------------------------------------------------------------------
# Define two dynamic rules: dlow & dhigh
OdataDT <- defineIntervedTRT(OdataDT, theta = c(0,1), ID = "ID", t = "t", I = "highA1c",
                          CENS = "C", TRT = "TI", MONITOR = "N", tsinceNis1 = "lastNat1",
                          new.TRT.names = c("dlow", "dhigh"), return.allcolumns = TRUE)
}

