% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DataStorageClass.R
\docType{class}
\name{DataStorageClass}
\alias{DataStorageClass}
\title{R6 class for storing, managing, subsetting and manipulating the input data.}
\format{An \code{\link{R6Class}} generator object}
\usage{
DataStorageClass
}
\description{
The class \code{DataStorageClass} is the only way the package uses to access the input data.
 The evaluated summary measures from sVar.object are stored as a matrix (\code{private$.mat.sVar}).
 Contains methods for replacing missing values with default in \code{gvars$misXreplace}.
 Also contains method for detecting / setting sVar variable type (binary, categor, contin).
 Contains methods for combining, subsetting, discretizing & binirizing summary measures \code{(sW,sA)}.
 For continous sVar this class provides methods for detecting / setting bin intervals,
 normalization, disretization and construction of bin indicators.
 The pointers to this class get passed on to \code{GenericModel} functions: \code{$fit()},
 \code{$predict()} and \code{$predictAeqa()}.
}
\details{
\itemize{
   \item{\code{YnodeVals}}
   \item{\code{det.Y}}
}
}
\section{Methods}{

\describe{
  \item{\code{new(Odata, nodes, YnodeVals, det.Y, ...)}}{...}
  \item{\code{def.types.sVar(type.sVar = NULL)}}{...}
  \item{\code{fixmiss_sVar()}}{...}
  \item{\code{set.sVar(name.sVar, new.type)}}{...}
  \item{\code{set.sVar.type(name.sVar, new.type)}}{...}
  \item{\code{get.sVar(name.sVar, new.sVarVal)}}{...}
  \item{\code{replaceOneAnode(AnodeName, newAnodeVal)}}{...}
  \item{\code{replaceManyAnodes(Anodes, newAnodesMat)}}{...}
  \item{\code{addYnode(YnodeVals, det.Y)}}{...}
  \item{\code{evalsubst(subset_exprs, subset_vars)}}{...}
  \item{\code{get.dat.sVar(rowsubset = TRUE, covars)}}{...}
  \item{\code{get.outvar(rowsubset = TRUE, var)}}{...}
  \item{\code{bin.nms.sVar(name.sVar, nbins)}}{...}
  \item{\code{detect.sVar.intrvls(name.sVar, nbins, bin_bymass, bin_bydhist, max_nperbin)}}{...}
  \item{\code{detect.cat.sVar.levels(name.sVar)}}{...}
  \item{\code{binirize.sVar(name.sVar, ...)}}{...}
  \item{\code{get.sVar.bw(name.sVar, intervals)}}{...}
  \item{\code{get.sVar.bwdiff(name.sVar, intervals)}}{...}
}
}

\section{Active Bindings}{

\describe{
   \item{\code{nobs}}{...}
   \item{\code{ncols.sVar}}{...}
   \item{\code{names.sVar}}{...}
   \item{\code{type.sVar}}{Named list of length \code{ncol(private$.mat.sVar)} with \code{sVar} variable types: "binary"/"categor"/"contin".}
   \item{\code{dat.sVar}}{...}
   \item{\code{ord.sVar}}{Ordinal (categorical) transformation of a continous covariate \code{sVar}.}
   \item{\code{active.bin.sVar}}{Name of active binarized cont sVar, changes as fit/predict is called (bin indicators are temp. stored in private$.mat.bin.sVar)}
   \item{\code{dat.bin.sVar}}{...}
   \item{\code{emptydat.sVar}}{...}
   \item{\code{emptydat.bin.sVar}}{...}
   \item{\code{noNA.Ynodevals}}{...}
   \item{\code{nodes}}{...}
}
}
\keyword{R6}
\keyword{class}

