% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlm_classification.R
\name{mlm_classification}
\alias{mlm_classification}
\title{Fit Machine Learning Classification Models}
\usage{
mlm_classification(
  formula,
  train_data,
  fit_models = c("ada", "et", "lightgbm", "dummy", "lr", "rf", "ridge", "knn", "dt",
    "gbc", "svm", "lda", "nb", "qda"),
  sort_v = c("Accuracy", "AUC", "Recall", "Precision", "F1", "Kappa", "MCC"),
  n_models = 9999,
  seed = NULL,
  ...
)
}
\arguments{
\item{formula}{The classification formula, as a formula object.}

\item{train_data}{A data.frame object that includes data to be trained on.}

\item{fit_models}{A character vector with all the possible Machine Learning
classifiers that are currently being fit, the user may specify a subset of
them using a character vector.
\tabular{rl}{
  ada \tab AdaBoost Classifier \cr
  dt \tab Decision Tree Classifier\cr
  dummy \tab Dummy Classifier\cr
  et \tab Extra Trees Classifier \cr
  gbc \tab Gradient Boosting Classifier\cr
  knn \tab K Neighbors Classifier\cr
  lda \tab Linear Discriminant Analysis\cr
  lightgbm \tab Light Gradient Boosting Machine\cr
  lr \tab Logistic Regression\cr
  nb \tab Naive Bayes \cr
  qda \tab Quadratic Discriminant Analysis\cr
  rf \tab Random Forest Classifier\cr
  ridge \tab Ridge Classifier\cr
  svm \tab SVM - Linear Kernel
}}

\item{sort_v}{A character vector indicating what to sort the tuned models on.}

\item{n_models}{An integer value defaulted to a large integer value to
return all possible models.}

\item{seed}{An integer value to set the seed of the `python` environment.
Default value is set to `NULL`.}

\item{...}{Additional arguments passed onto \link[stressor]{mlm_init}.}
}
\value{
A list object where the first entry is the models fitted and the
  second is the initial predictive accuracy on the random test data. Returns
  as two classes `"mlm_stressor"` and `"classifier"`.
}
\description{
Through the \href{https://pycaret.gitbook.io/docs/get-started/quickstart#classification}{PyCaret}
  module from `python`, this function fits many machine
  learning models simultaneously without requiring any `python`
  programming on the part of the user. This function is specifically
  designed for the classification models fitted by `PyCaret`.
}
\details{
`PyCaret` is a `python` module where machine learning models can be fitted with
  little coding by the user. The pipeline that `PyCaret` uses is a
  setup function to parameterize the data that is easy for all the models to
  fit on. Then the compare models function is executed, which fits all the models
  that are currently available. This process takes less than five minutes for
  data.frame objects that are less than 10,000 rows.
}
\examples{
\dontshow{if (python_avail()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
 lm_test <- data_gen_lm(20)
 binary_response <- sample(c(0, 1), 20, replace = TRUE)
 lm_test$Y <- binary_response
 mlm_class <- mlm_classification(Y ~ ., lm_test)
\dontshow{\}) # examplesIf}
}
