% Generated by roxygen2 (4.0.2): do not edit by hand
\name{stringi-search-regex}
\alias{stringi-search-regex}
\title{Regular Expressions in \pkg{stringi}}
\description{
A regular expression is a pattern describing, possibly in a very
abstract way, a part of text.
Thanks to many regex functions in \pkg{stringi},
regular expressions may be a very powerful tool in your hand
to perform string searching, substring extraction, string splitting, etc.,
tasks.
}
\details{
All \code{stri_*_regex} functions in \pkg{stringi} use
the \pkg{ICU} regex engine. Its settings may be tuned up (for example
to perform case-insensitive search), see the
\code{\link{stri_opts_regex}} function for more details.


Regular expression patterns in \pkg{ICU} are quite similar in form and
behavior to Perl's regexes.  Their implementation is loosely inspired
by JDK 1.4 \code{java.util.regex}.
\pkg{ICU} Regular Expressions conform to the Unicode Technical Standard #18
(see References section) and its features are summarized in
the ICU User Guide (see below). A good general introduction
to regexes is (Friedl, 2002).
Some general topics are also covered in the \R manual, see \link{regex}.
}
\section{\pkg{ICU} Regex Operators at a Glance}{


Here is a list of operators provided by the
ICU User Guide on regexes.

\tabular{ll}{
\strong{Operator} \tab    \strong{Description}\cr
\code{|} \tab 	Alternation. A|B matches either A or B.\cr
\code{*} \tab 	Match 0 or more times. Match as many times as possible.\cr
\code{+} \tab 	Match 1 or more times. Match as many times as possible.\cr
\code{?} \tab 	Match zero or one times. Prefer one.\cr
\code{{n}} \tab 	Match exactly n times.\cr
\code{{n,}} \tab 	Match at least n times. Match as many times as possible.\cr
\code{{n,m}} \tab 	Match between n and m times.
Match as many times as possible, but not more than m.\cr
\code{*?} \tab 	Match 0 or more times. Match as few times as possible.\cr
\code{+?} \tab 	Match 1 or more times. Match as few times as possible.\cr
\code{??} \tab 	Match zero or one times. Prefer zero.\cr
\code{{n}?} \tab 	Match exactly n times.\cr
\code{{n,}?} \tab 	Match at least n times, but no more than required
for an overall pattern match.\cr
\code{{n,m}?} \tab 	Match between n and m times. Match as few times
as possible, but not less than n.\cr
\code{*+} \tab 	Match 0 or more times. Match as many times as possible
when first encountered, do not retry with fewer even if overall match fails
(Possessive Match).\cr
\code{++} \tab 	Match 1 or more times. Possessive match.\cr
\code{?+} \tab 	Match zero or one times. Possessive match.\cr
\code{{n}+} \tab 	Match exactly n times.\cr
\code{{n,}+} \tab 	Match at least n times. Possessive Match.\cr
\code{{n,m}+} \tab 	Match between n and m times. Possessive Match.\cr
\code{(...)} \tab 	Capturing parentheses. Range of input that matched
the parenthesized subexpression is available after the match,
see \code{\link{stri_match}}.\cr
\code{(?:...)} \tab 	Non-capturing parentheses. Groups the included pattern,
but does not provide capturing of matching text. Somewhat more efficient
than capturing parentheses.\cr
\code{(?>...)} \tab 	Atomic-match parentheses. First match of the
parenthesized subexpression is the only one tried; if it does not lead to
an overall pattern match, back up the search for a match to a position
before the \code{(?>}\cr
\code{(?#...)} \tab 	Free-format comment \code{(?# comment )}.\cr
\code{(?=...)} \tab 	Look-ahead assertion. True if the parenthesized
pattern matches at the current input position, but does not advance
the input position.\cr
\code{(?!...)} \tab 	Negative look-ahead assertion. True if the
parenthesized pattern does not match at the current input position.
Does not advance the input position.\cr
\code{(?<=...)} \tab 	Look-behind assertion. True if the parenthesized
pattern matches text preceding the current input position, with the last
character of the match being the input character just before the current
position. Does not alter the input position. The length of possible strings
matched by the look-behind pattern must not be unbounded (no \code{*}
or \code{+} operators.)\cr
\code{(?<!...)} \tab 	Negative Look-behind assertion. True if the
parenthesized pattern does not match text preceding the current input
position, with the last character of the match being the input character
just before the current position. Does not alter the input position.
The length of possible strings matched by the look-behind pattern must
not be unbounded (no \code{*} or \code{+} operators.)\cr
\code{(?ismwx-ismwx:...)} \tab 	Flag settings. Evaluate the parenthesized
expression with the specified flags enabled or \code{-}disabled,
see also \code{\link{stri_opts_regex}}.\cr
\code{(?ismwx-ismwx)} \tab 	Flag settings. Change the flag settings.
Changes apply to the portion of the pattern following the setting.
For example, \code{(?i)} changes to a case insensitive match,
see also \code{\link{stri_opts_regex}}. \cr
}
}

\section{\pkg{ICU} Regex Metacharacters at a Glance}{


Here is a list of metacharacters provided by the
ICU User Guide on regexes.

\tabular{ll}{
\strong{Character}  \tab 	\strong{Description} \cr
\code{\\a} \tab Match a BELL, \code{\\u0007} \cr
\code{\\A} \tab Match at the beginning of the input. Differs from \code{^}
in that \code{\\A} will not match after a new line within the input. \cr
\code{\\b} \tab Match if the current position is a word boundary.
Boundaries occur at the transitions between word (\code{\\w}) and non-word
(\code{\\W}) characters, with combining marks ignored. For better word
boundaries, see ICU Boundary Analysis, e.g. \code{\link{stri_extract_all_words}} . \cr
\code{\\B} \tab Match if the current position is not a word boundary. \cr
\code{\\cX} \tab Match a control-\code{X} character. \cr
\code{\\d} \tab Match any character with the Unicode General Category of
Nd (Number, Decimal Digit.) \cr
\code{\\D} \tab Match any character that is not a decimal digit. \cr
\code{\\e} \tab Match an ESCAPE, \code{\\u001B}. \cr
\code{\\E} \tab Terminates a \code{\\Q} ... \code{\\E} quoted sequence. \cr
\code{\\f} \tab Match a FORM FEED, \code{\\u000C}. \cr
\code{\\G} \tab Match if the current position is at the end of the
previous match. \cr
\code{\\n} \tab Match a LINE FEED, \code{\\u000A}. \cr
\code{\\N{UNICODE CHARACTER NAME}} \tab Match the named character. \cr
\code{\\p{UNICODE PROPERTY NAME}} \tab Match any character with the
specified Unicode Property. \cr
\code{\\P{UNICODE PROPERTY NAME}} \tab Match any character not having
the specified Unicode Property. \cr
\code{\\Q} \tab Quotes all following characters until \code{\\E}. \cr
\code{\\r} \tab Match a CARRIAGE RETURN, \code{\\u000D}. \cr
\code{\\s} \tab Match a white space character. White space is defined
as \code{[\\t\\n\\f\\r\\p{Z}]}. \cr
\code{\\S} \tab Match a non-white space character. \cr
\code{\\t} \tab Match a HORIZONTAL TABULATION, \code{\\u0009}. \cr
\code{\\uhhhh} \tab Match the character with the hex value \code{hhhh}. \cr
\code{\\Uhhhhhhhh} \tab Match the character with the hex value \code{hhhhhhhh}.
Exactly eight hex digits must be provided, even though the largest
Unicode code point is \code{\\U0010ffff}. \cr
\code{\\w} \tab Match a word character. Word characters are
\code{[\\p{Alphabetic}\\p{Mark}\\p{Decimal_Number}\\p{Connector_Punctuation}\\u200c\\u200d]}. \cr
\code{\\W} \tab Match a non-word character. \cr
\code{\\x{hhhh}} \tab Match the character with hex value hhhh.
From one to six hex digits may be supplied. \cr
\code{\\xhh} \tab Match the character with two digit hex value hh \cr
\code{\\X} \tab Match a Grapheme Cluster. \cr
\code{\\Z} \tab Match if the current position is at the end of input,
 but before the final line terminator, if one exists. \cr
\code{\\z} \tab Match if the current position is at the end of input. \cr
\code{\\n} \tab 	Back Reference. Match whatever the nth capturing
group matched. n must be a number > 1 and < total number of capture
groups in the pattern. \cr
\code{\\0ooo} \tab Match an Octal character.  'ooo' is from one to three
octal digits.  0377 is the largest allowed Octal character.  The leading
zero is required; it distinguishes Octal constants from back references. \cr
\code{[pattern]} \tab Match any one character from the set.  \cr
\code{.} \tab Match any character. \cr
\code{^} \tab Match at the beginning of a line. \cr
\code{$} \tab Match at the end of a line. \cr
\code{\\} \tab [outside of sets] Quotes the following character.
Characters that must be quoted to be treated as literals are
\code{* ? + [ ( ) { } ^ $ | \\ .} \cr
\code{\\} \tab [inside sets] Quotes the following character.
Characters that must be quoted to be treated as literals are
\code{[ ] \\}; Characters that may need to be quoted, depending
on the context are \code{- &} \cr
}

For information on how to define character classes
in regexes, refer to \link{stringi-search-charclass}.
}

\section{Regex Functions in \pkg{stringi}}{

Note that if a given regex \code{pattern} is empty,
then all functions in \pkg{stringi} give \code{NA} in result
and generate a warning.
On a syntax error, a quite informative failure message is shown.

If you would like to search for a fixed pattern,
refer to \link{stringi-search-coll} or \link{stringi-search-fixed}.
This allows to do a locale-aware text lookup,
or a very fast exact-byte search, respectively.
}
\references{
\emph{Regular expressions} -- ICU User Guide,
 \url{http://userguide.icu-project.org/strings/regexp}

J.E.F. Friedl, \emph{Mastering Regular Expressions}, O'Reilly, 2002

\emph{Unicode Regular Expressions} -- Unicode Technical Standard #18,
\url{http://www.unicode.org/reports/tr18/}

\emph{Unicode Regular Expressions} -- Regex tutorial,
\url{http://www.regular-expressions.info/unicode.html}
}
\seealso{
Other search_regex: \code{\link{stri_opts_regex}};
  \code{\link{stringi-search}}

Other stringi_general_topics: \code{\link{stringi-arguments}};
  \code{\link{stringi-encoding}};
  \code{\link{stringi-locale}};
  \code{\link{stringi-package}};
  \code{\link{stringi-search-boundaries}};
  \code{\link{stringi-search-charclass}};
  \code{\link{stringi-search-coll}};
  \code{\link{stringi-search-fixed}};
  \code{\link{stringi-search}}
}

