% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/length.R
\name{stri_numbytes}
\alias{stri_numbytes}
\title{Count the Number of Bytes}
\usage{
stri_numbytes(str)
}
\arguments{
\item{str}{character vector or an object coercible to}
}
\value{
Returns an integer vector of the same length as \code{str}.
}
\description{
Counts the number of bytes needed to store
each string in the computer's memory.
}
\details{
Often, this is not the function you would normally use
in your string processing activities. See \code{\link{stri_length}} instead.

For 8-bit encoded strings, this is the same as \code{\link{stri_length}}.
For UTF-8 strings, the returned values may be greater
than the number of code points, as UTF-8 is not a fixed-byte encoding:
one code point may be encoded by 1-4 bytes
(according to the current Unicode standard).

Missing values are handled properly.

The strings do not need to be re-encoded to perform this operation.

The returned values do not include the trailing NUL bytes,
which are used internally to mark the end of string data (in C).
}
\examples{
stri_numbytes(letters)
stri_numbytes(c('abc', '123', '\u0105\u0104'))

\dontrun{
# this used to fail on Windows, where there were no native support
# for 4-bytes Unicode characters; see, however, stri_unescape_unicode():
stri_numbytes('\U001F600') # compare stri_length('\U001F600')
}

}
\seealso{
The official online manual of \pkg{stringi} at \url{https://stringi.gagolewski.com/}

Gagolewski M., \pkg{stringi}: Fast and portable character string processing in R, \emph{Journal of Statistical Software} 103(2), 2022, 1-59, \doi{10.18637/jss.v103.i02}

Other length: 
\code{\link{\%s$\%}()},
\code{\link{stri_isempty}()},
\code{\link{stri_length}()},
\code{\link{stri_pad_both}()},
\code{\link{stri_sprintf}()},
\code{\link{stri_width}()}
}
\concept{length}
\author{
\href{https://www.gagolewski.com/}{Marek Gagolewski} and other contributors
}
