% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sub.R
\name{stri_sub}
\alias{stri_sub}
\alias{stri_sub<-}
\alias{stri_sub_replace}
\title{Extract a Substring From or Replace a Substring In a Character Vector}
\usage{
stri_sub(
  str,
  from = 1L,
  to = -1L,
  length,
  use_matrix = TRUE,
  ignore_negative_length = FALSE
)

stri_sub(str, from = 1L, to = -1L, length, omit_na = FALSE, use_matrix = TRUE) <- value

stri_sub_replace(..., replacement, value = replacement)
}
\arguments{
\item{str}{character vector}

\item{from}{integer vector giving the start indexes; alternatively,
if \code{use_matrix=TRUE},
a two-column matrix of type \code{cbind(from, to)}
(unnamed columns or the 2nd column named other than \code{length})
or \code{cbind(from, length=length)} (2nd column named \code{length})}

\item{to}{integer vector giving the end indexes; mutually exclusive with
\code{length} and \code{from} being a matrix}

\item{length}{integer vector giving the substring lengths;
mutually exclusive with \code{to} and \code{from} being a matrix}

\item{use_matrix}{single logical value; see \code{from}}

\item{ignore_negative_length}{single logical value; whether
negative lengths should be ignored or result in missing values}

\item{omit_na}{single logical value; indicates whether missing values
in any of the indexes or in \code{value} leave the corresponding input string
unchanged [replacement function only]}

\item{value}{a character vector defining the replacement strings
[replacement function only]}

\item{...}{arguments to be passed to \code{stri_sub<-}}

\item{replacement}{alias of \code{value} [wherever applicable]}
}
\value{
\code{stri_sub} and \code{stri_sub_replace} return a character vector.
\code{stri_sub<-} changes the \code{str} object 'in-place'.
}
\description{
\code{stri_sub} extracts particular substrings at code point-based
index ranges provided. Its replacement version allows to substitute
(in-place) parts of
a string with given replacement strings. \code{stri_sub_replace}
is its forward pipe operator-friendly variant that returns
a copy of the input vector.

For extracting/replacing multiple substrings from/within each string, see
\code{\link{stri_sub_all}}.
}
\details{
Vectorized over \code{str}, [\code{value}], \code{from} and
(\code{to} or \code{length}). Parameters
\code{to} and \code{length} are mutually exclusive.

Indexes are 1-based, i.e., the start of a string is at index 1.
For negative indexes in \code{from} or \code{to},
counting starts at the end of the string.
For instance, index -1 denotes the last code point in the string.
Non-positive \code{length} gives an empty string.

Argument \code{from} gives the start of a substring to extract.
Argument \code{to} defines the last index of a substring, inclusive.
Alternatively, its \code{length} may be provided.

If \code{from} is a two-column matrix, then these two columns are
used as \code{from} and \code{to}, respectively,
unless the second column is named \code{length}.
In such a case anything passed
explicitly as \code{to} or \code{length} is ignored.
Such types of index matrices are generated by \code{\link{stri_locate_first}}
and \code{\link{stri_locate_last}}. If extraction based on
\code{\link{stri_locate_all}} is needed, see
\code{\link{stri_sub_all}}.

In \code{stri_sub}, out-of-bound indexes are silently
corrected. If \code{from} > \code{to}, then an empty string is returned.
By default, negative \code{length} results in the corresponding output being
\code{NA}, see \code{ignore_negative_length}, though.

In \code{stri_sub<-}, some configurations of indexes may work as
substring 'injection' at the front, back, or in middle.
Negative \code{length} does not alter the corresponding input string.

If both \code{to} and \code{length} are provided,
\code{length} has priority over \code{to}.

Note that for some Unicode strings, the extracted substrings might not
be well-formed, especially if input strings are not normalized
(see \code{\link{stri_trans_nfc}}),
include byte order marks, Bidirectional text marks, and so on.
Handle with care.
}
\examples{
s <- c("spam, spam, bacon, and spam", "eggs and spam")
stri_sub(s, from=-4)
stri_sub(s, from=1, length=c(10, 4))
(stri_sub(s, 1, 4) <- 'stringi')

x <- c('12 3456 789', 'abc', '', NA, '667')
stri_sub(x, stri_locate_first_regex(x, '[0-9]+')) # see stri_extract_first
stri_sub(x, stri_locate_last_regex(x, '[0-9]+'))  # see stri_extract_last

stri_sub_replace(x, stri_locate_first_regex(x, '[0-9]+'),
    omit_na=TRUE, replacement='***') # see stri_replace_first
stri_sub_replace(x, stri_locate_last_regex(x, '[0-9]+'),
    omit_na=TRUE, replacement='***') # see stri_replace_last


\dontrun{x |> stri_sub_replace(1, 5, replacement='new_substring')}
}
\seealso{
The official online manual of \pkg{stringi} at \url{https://stringi.gagolewski.com/}

Gagolewski M., \pkg{stringi}: Fast and portable character string processing in R, \emph{Journal of Statistical Software} 103(2), 2022, 1-59, \doi{10.18637/jss.v103.i02}

Other indexing: 
\code{\link{stri_locate_all_boundaries}()},
\code{\link{stri_locate_all}()},
\code{\link{stri_sub_all}()}
}
\concept{indexing}
\author{
\href{https://www.gagolewski.com/}{Marek Gagolewski} and other contributors
}
