% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aliases.R, R/string_tools.R
\name{string_vec_alias}
\alias{string_vec_alias}
\alias{string_vec}
\alias{stvec}
\title{Efficient creation of string vectors with optional interpolation}
\usage{
string_vec_alias(
  .cmat = FALSE,
  .nmat = FALSE,
  .df = FALSE,
  .df.convert = TRUE,
  .last = NULL,
  .delim = c("{", "}"),
  .split = TRUE,
  .protect.vars = TRUE,
  .sep = NULL,
  .collapse = NULL,
  .namespace = NULL
)

string_vec(
  ...,
  .cmat = FALSE,
  .nmat = FALSE,
  .df = FALSE,
  .df.convert = TRUE,
  .delim = c("{", "}"),
  .envir = parent.frame(),
  .split = TRUE,
  .protect.vars = TRUE,
  .sep = NULL,
  .last = NULL,
  .collapse = NULL,
  .namespace = NULL
)

stvec(
  ...,
  .cmat = FALSE,
  .nmat = FALSE,
  .df = FALSE,
  .df.convert = TRUE,
  .delim = c("{", "}"),
  .envir = parent.frame(),
  .split = TRUE,
  .protect.vars = TRUE,
  .sep = NULL,
  .last = NULL,
  .collapse = NULL,
  .namespace = NULL
)
}
\arguments{
\item{.cmat}{Logical scalar (default is \code{FALSE}), integer or complex with integer values.
If \code{TRUE}, we try to coerce the result into a \strong{character} matrix. The number of rows and columns
is deduced from the look of the arguments. An integer indicates the number of rows.
If a complex, the imaginary part represents the number of columns. Ex: \code{5i} means
5 columns, \code{3 + 2i} means 3 rows and 2 columns.

The matrix is always filled by row.}

\item{.nmat}{Logical scalar (default is \code{FALSE}), integer or complex with integer values.
If \code{TRUE}, we try to coerce the result into a \strong{numeric} matrix. The number of rows and columns
is deduced from the look of the arguments. An integer indicates the number of rows.
If a complex, the imaginary part represents the number of columns. Ex: \code{5i} means
5 columns, \code{3 + 2i} means 3 rows and 2 columns.

The matrix is always filled by row. Non numbers are silently turned to NA.}

\item{.df}{Logical scalar (default is \code{FALSE}), integer, complex with integer values, or
character vector.
If \code{TRUE}, we try to coerce the result into a \code{data.frame}. The number of rows and columns
is deduced from the look of the arguments. An integer indicates the number of rows.
If a complex, the imaginary part represents the number of columns. Ex: \code{5i} means
5 columns, \code{3 + 2i} means 3 rows and 2 columns.

If a character vector: it should give the column names. Note that if the vector
is of length 1, its values are comma separated (i.e. the value \code{"id, name"} is
identical to \code{c("id", "name")}).

Note that the columns that can be converted to numeric are converted to numeric.
The other columns are in string form. Monitor this behavior with \code{.df.convert}.}

\item{.df.convert}{Logical scalar, default is \code{TRUE}. Only used when the result is
to be converted to a data frame (with the argument \code{.df}). If \code{TRUE}, any column
looking like a numeric vector is converted to numeric. Otherwise all columns
are character strings.}

\item{.last}{Character scalar, a function, or \code{NULL} (default). If provided and character:
it must be an \code{string_magic} chain of operations of the form \code{"'arg1'op1, op2, etc"}. All these operations
are applied just before returning the vector. If a function,
it will be applied to the resulting vector.}

\item{.delim}{Character vector of length 1 or 2. Default is \code{c("{", "}")}. Defines
the opening and the closing delimiters for interpolation.

If of length 1, it must be of the form: 1) the opening delimiter,
2) a single space, 3) the closing delimiter. Ex: \code{".[ ]"} is equivalent to \code{c(".[", "]")}.
The default value is equivalent to \code{"{ }"}.

[ ]: R:\%20
[", "]: R:\%22,\%20\%22}

\item{.split}{Logical or a character symbol, default is \code{TRUE}. If \code{TRUE},
the character vectors are split with respect to commas (default). If \code{FALSE}, no
splitting is performed. If a character symbol, the string vector will be split
according to this symbol. Note that any space after the symbol (including tabs and
newlines) is discarded.

Ex: by default \code{string_vec("hi, there")} leads to the vector \code{c("hi", "there")}.}

\item{.protect.vars}{Logical scalar, default is \code{TRUE}. If \code{TRUE}, then only
arguments equal to a "natural" character scalar are comma-split and interpolated,
other arguments are not touched. Ex: \code{string_vec("x{1:5}")} will lead to a vector of
length 5 ("x1" to "x5"), while \code{z = "x{1:5}"} followed by \code{string_vec(z)} leads
to a vector of length 1: \code{"x{1:5}"}. If \code{FALSE}, comma-splitting and interpolation
is performed on all variables.}

\item{.sep}{Character scalar or \code{NULL} (default). If not \code{NULL}, the function
\code{\link[base:paste]{base::paste()}} is applied to the resulting vector with \code{sep = .sep}.}

\item{.collapse}{Character scalar or \code{NULL} (default). If not \code{NULL}, the function
\code{\link[base:paste]{base::paste()}} is applied to the resulting vector with \code{collapse = .collapse}.

If so, pass the name of your package in this argument so that your function can access
the new \code{string_magic} operations defined within your package.}

\item{.namespace}{Character scalar or \code{NULL} (default). \strong{Only useful for package developers.}
As a regular end-user you shouldn't care! If your package uses \code{string_magic}, you should care.
It is useful \strong{only} if your package uses 'custom' \code{string_magic} operations, set with
\code{\link[=string_magic_register_fun]{string_magic_register_fun()}} or \code{\link[=string_magic_register_ops]{string_magic_register_ops()}}.}

\item{...}{Character vectors that will be vectorized. If commas are present in the
character vector, it will be split with respect to commas and following blanks.
The vectors can contain any interpolation in the form \code{"{var}"} and
any \code{\link[=string_magic]{string_magic()}} operation can be applied. To change the delimiters for interpolation,
see \code{.delim}. Named arguments are used in priority for variable substitution,
otherwise the value of the variables to be interpolated are fetched in the calling environment
(see argument \code{.envir}).

Note, importantly, that interpolation and comma splitting are performed on "natural" vectors only.
That is: \code{string_vec("x{1:5}")} will lead to a vector of length 5 ("x1" to "x5"), while \code{z = "x{1:5}"}
followed by \code{string_vec(z)} leads to a vector of length 1: \code{"x{1:5}"}. To change this behavior and
obtain equivalent results, use \code{.protect.vars = FALSE}.}

\item{.envir}{An environment used to evaluate the variables in \code{"{}"}. By default the variables are
evaluated using the environment from where the function is called or using the named
arguments passed to the function.}
}
\value{
By default this function returns a string vector, the length of which depends on the arguments.

This result can be processed with the arguments \code{cmat}, \code{nmat} and \code{.df} which will
try to coerce the result into a character matrix, a numeric matrix , or a data frame, respectively.
}
\description{
Create string vectors in multiple ways: 1) add successive string elements (like in \code{c()}),
or 2) write a character string that will be broken with respect to commas
(\code{"hi, there"} becomes \code{c("hi", "there")}), or 3) interpolate variables in
character strings (\code{"x{1:2}"} becomes \code{c("x1", "x2")}) with full access to
\code{\link[=string_magic]{string_magic()}} operations, or any combination of the three.
}
\details{
The main objective of this function is to simplify the creation of small character vectors.
By default, you can pass a character string of length 1 with values separated with commas
and a character vector will be returned.

You can use interpolation using curly brackets (see \code{string_magic()}). You can pass
values for the interpolation directly in the arguments (this is why all
arguments start with a dot).

By default character values containing commas are split with respect to the commas
to create vectors. To change this behavior, see the argument \code{.split}.

The default of the argument \code{.protect.vars} is \code{FALSE} so as to avoid unwanted
comma-splitting and interpolations. The main use case of this function is
the creation of small string vectors, which can be written directly at
function call.

Customize the default of this function with \code{\link[=string_vec_alias]{string_vec_alias()}}.
}
\section{Functions}{
\itemize{
\item \code{string_vec_alias()}: Create \code{string_vec} aliases with custom defaults

\item \code{stvec()}: Alias to \code{string_vec}

}}
\examples{

# illustrating comma-splitting and interpolation
string_vec("x1, y2, z{4:5}")

# variable protection
x = "x{1:5}"
string_vec(x, "y{1:2}")

# without protection => interpolation takes place
string_vec(x, "y{1:2}", .protect.vars = FALSE)

# removing comma splitting
string_vec("Hi, said Charles.", "Hi, said {girl}.", girl = "Julia", .split = FALSE)

# changing the delimiters for interpolation
pkg = "\\\\usepackage[usenames,dvipsnames]{xcolor}"
string_vec("\\\\usepackage{.[S!graphicx, fourier, standalone]}", 
           pkg, .delim = ".[ ]")

#
# Customization
#

# Unhappy about the defaults? Create an alias!

# we create a "matrix generator"
matgen = string_vec_alias(.nmat = TRUE, .last = "'\n'split")

matgen("5, 4, 3
        8, 6, 2")

}
\seealso{
Other tools with aliases: 
\code{\link{cat_magic_alias}()},
\code{\link{string_clean_alias}()},
\code{\link{string_magic}()},
\code{\link{string_magic_alias}()},
\code{\link{string_ops_alias}()}
}
\author{
Laurent Berge
}
\concept{tools with aliases}
