% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xyLayout.R
\name{xyLayout}
\alias{xyLayout}
\alias{xyLayout.data.frame}
\alias{xyLayout.default}
\alias{xyLayout.list}
\alias{xyLayout.matrix}
\title{xyLayout}
\usage{
xyLayout(xylay, ...)

\method{xyLayout}{list}(xylay = list(),
  n = stop("Number of conditioning factors is missing"))

\method{xyLayout}{matrix}(xylay, n)

\method{xyLayout}{data.frame}(xylay, n)

\method{xyLayout}{default}(xylay, n)
}
\arguments{
\item{xylay}{An appropriate list, matrix, or vector for determining the
plot structure. Can also be missing, length 0, etc.}

\item{n}{The number of conditioning factors. The integers in the combined list
that is created will be a permutation of 1, 2, \ldots ,n .}

\item{\ldots}{x and/or y vector for xylay list. The remaining component will be
constructed as needed.}
}
\value{
A list of class "xyLayout" suitable for the xyLayout argument of 
\code{strucplot}.
}
\description{
Unexported generic and methods used by \code{strucplot} to check and
fix or create a \code{xyLayout} list.
}
\details{
The various methods provide convenience and flexibility for specifying
the \code{xyLayout} list argument that controls the format of strucplot
displays. Essentially any sensible way of specifying the xyLayout should
work. See the Help page for \code{\link{strucplot}} for details.
}
\section{Methods (by class)}{
\itemize{
\item \code{list}: List method.

\item \code{matrix}: Matrix method.

\item \code{data.frame}: Data frame method.

\item \code{default}: Default methods in which the individual components
are given as 1 or 2 vectors of integers.
}}
\seealso{
\code{\link{strucplot}}
}

