\name{addData}
\alias{addData}
\title{Adds new data columns to a data frame}
\usage{
  addData(data, newData, byCol, thenByCol = NULL,
    exact = TRUE)
}
\arguments{
  \item{data}{Data frame containing your main data.}

  \item{newData}{Data frame containing information you want
  to add to 'data'.}

  \item{byCol}{character, key column.}

  \item{thenByCol}{character, key column level 2.}

  \item{exact}{logical, TRUE matches keys exact.}
}
\value{
  data.frame the original data frame containing additional
  columns.
}
\description{
  \code{addData} Adds columns in 'newData' to 'data' by
  column 'byCol'.
}
\details{
  Information in columns in data frame 'newData' is added
  to data frame 'data' based on value in column 'byCol' and
  optionally on 'thenByCol'.
}
\examples{
# Get marker names for Promega PowerPlex ESX 17.
x <- data.frame(Marker = getKit("ESX17")$locus)
# Get offsets for Promega PowerPlex ESX 17.
y <- data.frame(Marker = getKit("ESX17")$locus, Offset = getKit("ESX17")$offset)
# Get other kit information using string name.
z <- addData(data=x, newData=y, byCol="Marker")
print(x)
print(y)
print(z)
}
\keyword{internal}

