% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/removeSpike.r
\name{removeSpike}
\alias{removeSpike}
\title{Remove Spikes}
\usage{
removeSpike(data, spike, invert = FALSE, debug = FALSE)
}
\arguments{
\item{data}{data.frame with data to remove spikes from.}

\item{spike}{data.frame with list of spikes.}

\item{invert}{logical FALSE to remove spikes, TRUE to keep spikes.}

\item{debug}{logical indicating printing debug information.}
}
\value{
data.frame with spikes removed.
}
\description{
Remove spikes from data.
}
\details{
Removes identified spikes from the dataset. Spikes are identified using the
function \code{\link{calculateSpike}} and provided as a separate dataset.
NB! Samples must have unique identifiers.
Some laboratories use non-unique names for e.g. negative controls. To allow
identification of specific samples when multiple batches are imported into
one dataset an id is automatically created by combining the sample name and
the file name. This work well as long as there is at most 1 identically
named sample in each file (batch). To enable multiple identically named
samples in one file, the sample names can be prefixed with the lane or well
number before importing them to STR-validator.
}

