% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SL_tbl_trans.R
\name{regularise_time}
\alias{regularise_time}
\title{regularise_time}
\usage{
regularise_time(tab, ..., blocks = c("epoch", "day"), add_NAs = TRUE,
  study_duration = getOption("SL_duration"),
  start_date = getOption("SL_start"),
  epoch_levels = getOption("SL_epoch_levels"),
  epoch_ubs = getOption("SL_epoch_ubs"),
  uid_range = getOption("SL_uids"), date_range = seq(from = start_date,
  by = 1, length.out = study_duration))
}
\arguments{
\item{tab}{An \code{SL_tibble} as returned
by the function \code{\link[studentlife]{load_SL_tibble}}.
The \code{SL_tibble} must have some date-time information.}

\item{...}{Arguments passed to \code{\link[dplyr]{summarise}},
used to aggregate values when multiple
observations are encountered in a block. Any columns
not specified here or under \code{blocks} will be dropped.}

\item{blocks}{A character vector naming one or more of the
block options "hour", "epoch", "day", "week", "weekday", "month" or "date".
If not present as column names in
\code{tab}, an attempt will be made to infer the blocks from existing
time information with \code{\link[studentlife]{add_block_labels}}.
The returned \code{data.frame} will
have one observation (possibly \code{NA}) for each block.}

\item{add_NAs}{A logical. If TRUE then NAs will be introduced
to fill missing blocks.}

\item{study_duration}{Integer. The duration of the StudentLife
study in days. This parameter does nothing if \code{limit_date_range}
it \code{TRUE}.}

\item{start_date}{Date. The date that the StudentLife study started.}

\item{epoch_levels}{A character vector of epoch labels.}

\item{epoch_ubs}{An integer vector that defines the hour that is
the upper boundary of each epoch.}

\item{uid_range}{An integer vector. The range of uids in
the StudentLife study.}

\item{date_range}{A vector of dates to be
used if \code{limit_date_range} is \code{FALSE}.}
}
\description{
Transform an \code{SL_tibble} (as produced by
\code{\link[studentlife]{load_SL_tibble}})
in such a way that the observations are aggregated in
equal length intervals called 'blocks' (for more
information on blocks see
\code{\link[studentlife]{add_block_labels}}).
}
\examples{
d <- tempdir()
download_studentlife(location = d, url = "testdata")

tab <- load_SL_tibble(
  loc = d, schema = "sensing", table = "activity", csv_nrows = 10)

r_tab <- regularise_time(
  tab, blocks = c("day","weekday"),
  act_inf = max(activity_inference), add_NAs = FALSE)

r_tab

}
