% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/relevel.R
\name{relocate_eq_assign}
\alias{relocate_eq_assign}
\title{Relocate the expressions containing the token \code{EQ_ASSIGN} within the nested
parse table}
\usage{
relocate_eq_assign(pd)
}
\arguments{
\item{pd}{A parse table.}
}
\description{
Although syntactically identical, \code{\link[utils:getParseData]{utils::getParseData()}} does not produce
the same hierarchy of the parse table (parent and id relationship) for \code{<-}
and \code{=} (See 'Examples').
This is considered to be a bug and causes problems because the
nested parse table constructed with \code{\link[=compute_parse_data_nested]{compute_parse_data_nested()}} is not
consistent if \code{EQ_ASSIGN} occurs in the expression to style. In particular,
\code{EQ_ASSIGN} and the tokens to its left and right are located too high up in
the hierarchy of the nested parse data. Hence, this function wraps the
sub-expression into an expression, similar to \code{\link[=wrap_expr_in_curly]{wrap_expr_in_curly()}}.
Since \code{wrap_expr_in_curly()} is called from within a visitor
(and \code{relocate_eq_assign()} not), we need to
wrap the the implementation \code{\link[=relocate_eq_assign_nest]{relocate_eq_assign_nest()}} that operates on
\emph{nests} into a visitor call.
}
\examples{
styler:::get_parse_data("a <- b <- 3")
styler:::get_parse_data("a  = b = 3")
styler:::get_parse_data(
  "x = 5
  if(x >= 5)
  y = TRUE else
  y = FALSE",
)
styler:::get_parse_data(
  "x <- 5
  if(x >= 5)
  y <- TRUE else
  y <- FALSE",
)
}
\keyword{internal}
