% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rules-line-break.R, R/rules-spacing.R
\name{set_line_break_around_curly_curly}
\alias{set_line_break_around_curly_curly}
\alias{set_space_in_curly_curly}
\title{Styling around \code{\{\{}}
\usage{
set_line_break_around_curly_curly(pd)

set_space_in_curly_curly(pd)
}
\arguments{
\item{pd}{A parse table.}
}
\description{
With {rlang} version 0.4, a new syntactic sugar is introduced, the
curly-curly operator. It interprets this code in a special way:
\code{call(\{\{ x \}\})}. See this
\href{https://www.tidyverse.org/articles/2019/06/rlang-0-4-0/}{blog post}
on the topic. Here, the curly-curly sugar is understood as two opening
curly braces, followed by an expression followed by two closing curly braces,
e.g. \code{\{\{1\}\}}. \code{\{\{1\} + 1\}} does not contain the curly-curly syntactic
sugar according to the above definition. On the other hand \code{\{\{ x + y \}\}}
is recognized by styler as containing it (and is parsable code)
but will most likely give an error at runtime because the way the syntactic
suggar is defined in rlang is to use a single token within curly-curly. In
addition, because rlang parses \code{\{\{} in a special way (just as \code{!!}), the
expression \code{\{\{ x \}\}} will give a runtime error when used outside of a
context that is capable of handling it, e.g. on the top level (that is, not
within function call like \code{rlang_fun(\{\{ x \}\})}) or within a base R
function such as \code{\link[=c]{c()}}. However, these differences are assumed to be
irrelevant for styling curly-curly, as much as they were for styling \code{!!}.
curly-curly affects styling of line break and spaces, namely:
}
\details{
\itemize{
\item No line break after first or second \code{\{}, before third and fourth \code{\{}.
\item No space after first and third \code{\{}, one space after second and before third
\code{\}}.
\item No line breaks within curly-curly, e.g. \code{\{\{ x \}\}} can only contain line
breaks after the last brace or before the first brace. But these are not
dependent on curly-curly specifically.
}
}
\seealso{
style_text_without_curly_curly
}
\keyword{internal}
